/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.persistence;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.junit.JUnitThreadTrackerRule;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class EventLoggerRecoverCorruptTest {
    @ClassRule
    public static final JUnitThreadTrackerRule tracker = new JUnitThreadTrackerRule();
    static final String CACHE_NAME = "update-cache";
    private static String tmpDirectory;

    @BeforeClass
    public static void setUpTempDir() {
        tmpDirectory = CommonsTestingUtil.tmpDirectory(EventLoggerRecoverCorruptTest.class);
        new File(tmpDirectory).mkdirs();
    }

    @AfterClass
    public static void clearTempDir() {
        Util.recursiveFileRemove((String)tmpDirectory);
    }

    @Test
    public void testAllEntriesRecovered() throws Exception {
        InputStream is = FileLookupFactory.newInstance().lookupFile("sfs/corrupt/___event_log_cache.dat", Thread.currentThread().getContextClassLoader());
        Files.copy(is, Paths.get(tmpDirectory, new String[0]).resolve("update-cache.dat"), StandardCopyOption.REPLACE_EXISTING);
        final Configuration config = ((SingleFileStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addSingleFileStore().segmented(false)).location(tmpDirectory).build();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            public void call() {
                Cache cache = this.cm.createCache(EventLoggerRecoverCorruptTest.CACHE_NAME, config);
                Assert.assertEquals((long)37L, (long)cache.size());
            }
        });
    }
}

