/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.StringBuilderWriter;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.test.junit.JUnitThreadTrackerRule;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.ServerConfigurationSerializer;
import org.infinispan.server.configuration.endpoint.EndpointConfiguration;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.network.SocketBinding;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.WildFlyElytronCredentialStoreProvider;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

@RunWith(value=Parameterized.class)
public class ServerConfigurationParserTest {
    @ClassRule
    public static final JUnitThreadTrackerRule tracker = new JUnitThreadTrackerRule();
    private final MediaType type;

    @BeforeClass
    public static void setup() {
        System.setProperty("org.infinispan.configuration.clear-text-secrets", "true");
        ServerConfigurationParserTest.registerSecurityProviders();
        ServerConfigurationParserTest.createCredentialStore(ServerConfigurationParserTest.getConfigPath().resolve("credentials.pfx"), "secret");
    }

    @AfterClass
    public static void cleanup() {
        System.clearProperty("org.infinispan.configuration.clear-text-secrets");
    }

    @Parameterized.Parameters(name="{0}")
    public static Iterable<MediaType> data() {
        return Arrays.asList(MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_YAML);
    }

    public ServerConfigurationParserTest(MediaType type) {
        this.type = type;
    }

    @Test
    public void testParser() throws IOException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        URL url = fileLookup.lookupFileLocation("configuration/" + this.getClass().getSimpleName() + "." + this.type.getSubType().toLowerCase(Locale.ROOT), ServerConfigurationParserTest.class.getClassLoader());
        Properties properties = new Properties();
        properties.setProperty("infinispan.server.config.path", ServerConfigurationParserTest.getConfigPath().toString());
        properties.setProperty("infinispan.server.home.path", Paths.get(System.getProperty("build.directory"), new String[0]).toString());
        ParserRegistry registry = new ParserRegistry(this.getClass().getClassLoader(), false, properties);
        ConfigurationBuilderHolder holder = registry.parse(url);
        GlobalConfiguration global = holder.getGlobalConfigurationBuilder().build();
        ServerConfiguration serverConfiguration = (ServerConfiguration)global.module(ServerConfiguration.class);
        this.validateConfiguration(serverConfiguration);
        for (MediaType t : ServerConfigurationParserTest.data()) {
            StringBuilderWriter sw = new StringBuilderWriter();
            ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(t).build();
            try {
                new ServerConfigurationSerializer().serialize(w, serverConfiguration);
            }
            finally {
                if (w == null) continue;
                w.close();
            }
        }
    }

    private void validateConfiguration(ServerConfiguration configuration) {
        Assert.assertEquals((long)2L, (long)configuration.networkInterfaces().size());
        NetworkAddress defaultInterface = (NetworkAddress)configuration.networkInterfaces().get("default");
        Assert.assertNotNull((Object)defaultInterface);
        Assert.assertTrue((boolean)defaultInterface.getAddress().isLoopbackAddress());
        Map socketBindings = configuration.socketBindings();
        Assert.assertEquals((long)5L, (long)socketBindings.size());
        Assert.assertEquals((long)11221L, (long)((SocketBinding)socketBindings.get("memcached")).getPort());
        Assert.assertEquals((long)12221L, (long)((SocketBinding)socketBindings.get("memcached-2")).getPort());
        Assert.assertEquals((long)11222L, (long)((SocketBinding)socketBindings.get("default")).getPort());
        Assert.assertEquals((long)11223L, (long)((SocketBinding)socketBindings.get("hotrod")).getPort());
        Assert.assertEquals((long)8080L, (long)((SocketBinding)socketBindings.get("rest")).getPort());
        List realms = configuration.security().realms().realms();
        Assert.assertEquals((long)3L, (long)realms.size());
        RealmConfiguration realmConfiguration = (RealmConfiguration)realms.get(0);
        Assert.assertEquals((Object)"default", (Object)realmConfiguration.name());
        realmConfiguration = (RealmConfiguration)realms.get(1);
        Assert.assertEquals((Object)"using-credentials", (Object)realmConfiguration.name());
        Map dataSources = configuration.dataSources();
        Assert.assertEquals((long)2L, (long)dataSources.size());
        DataSourceConfiguration dataSource = (DataSourceConfiguration)dataSources.get("database");
        Assert.assertEquals((Object)"jdbc/database", (Object)dataSource.jndiName());
        Assert.assertEquals((Object)"jdbc:h2:tcp://${org.infinispan.test.host.address}:1521/test", (Object)dataSource.url());
        Assert.assertEquals((Object)"test", (Object)dataSource.username());
        Assert.assertEquals((Object)"test", (Object)new String(dataSource.password()));
        Assert.assertEquals((Object)"SELECT 1", (Object)dataSource.initialSql());
        Assert.assertEquals((Object)"org.h2.Driver", (Object)dataSource.driver());
        Assert.assertEquals((long)10L, (long)dataSource.maxSize());
        Assert.assertEquals((long)1L, (long)dataSource.minSize());
        Assert.assertEquals((long)1L, (long)dataSource.initialSize());
        Assert.assertEquals((long)1L, (long)dataSource.connectionProperties().size());
        Assert.assertEquals((long)10000L, (long)dataSource.leakDetection());
        Assert.assertEquals((long)1000L, (long)dataSource.backgroundValidation());
        Assert.assertEquals((long)500L, (long)dataSource.validateOnAcquisition());
        Assert.assertEquals((Object)"somevalue", dataSource.connectionProperties().get("someproperty"));
        dataSource = (DataSourceConfiguration)dataSources.get("database-with-credential");
        Assert.assertEquals((Object)"test", (Object)new String(dataSource.password()));
        List connectors = ((EndpointConfiguration)configuration.endpoints().endpoints().get(0)).connectors();
        Assert.assertEquals((long)3L, (long)connectors.size());
        Assert.assertTrue((boolean)(connectors.get(0) instanceof HotRodServerConfiguration));
        Assert.assertTrue((boolean)(connectors.get(1) instanceof RestServerConfiguration));
        Assert.assertTrue((boolean)(connectors.get(2) instanceof MemcachedServerConfiguration));
        SinglePortRouterConfiguration singlePortRouter = ((EndpointConfiguration)configuration.endpoints().endpoints().get(0)).singlePortRouter();
        Assert.assertEquals((Object)((SocketBinding)socketBindings.get("default")).getAddress().getAddress().getHostAddress(), (Object)singlePortRouter.host());
        Assert.assertEquals((long)((SocketBinding)socketBindings.get("default")).getPort(), (long)singlePortRouter.port());
        Assert.assertEquals((long)((SocketBinding)socketBindings.get("memcached")).getPort(), (long)((ProtocolServerConfiguration)((EndpointConfiguration)configuration.endpoints().endpoints().get(0)).connectors().get(2)).port());
        Assert.assertEquals((Object)"strongPassword", (Object)new String((char[])realmConfiguration.ldapConfiguration().attributes().attribute((Enum)Attribute.CREDENTIAL).get()));
        Assert.assertEquals((Object)"secret", (Object)new String((char[])realmConfiguration.serverIdentitiesConfiguration().sslConfiguration().trustStore().attributes().attribute((Enum)Attribute.PASSWORD).get()));
        Assert.assertEquals((Object)"1fdca4ec-c416-47e0-867a-3d471af7050f", (Object)new String((char[])realmConfiguration.tokenConfiguration().oauth2Configuration().attributes().attribute((Enum)Attribute.CLIENT_SECRET).get()));
        Assert.assertEquals((Object)"password", (Object)new String((char[])realmConfiguration.serverIdentitiesConfiguration().sslConfiguration().keyStore().attributes().attribute((Enum)Attribute.KEYSTORE_PASSWORD).get()));
    }

    public static Path getConfigPath() {
        return Paths.get(System.getProperty("build.directory"), "test-classes", "configuration");
    }

    public static void registerSecurityProviders() {
        WildFlyElytronCredentialStoreProvider provider = WildFlyElytronCredentialStoreProvider.getInstance();
        if (Security.getProvider(provider.getName()) == null) {
            Security.insertProviderAt((Provider)provider, 1);
        }
    }

    static void addCredential(KeyStoreCredentialStore store, String alias, String credential) {
        try {
            store.store(alias, (Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])credential.toCharArray())), null);
            store.flush();
        }
        catch (CredentialStoreException e) {
            throw new RuntimeException(e);
        }
    }

    static KeyStoreCredentialStore newCredentialStore(Path location, String secret) {
        Exceptions.unchecked(() -> {
            Files.deleteIfExists(location);
            Files.createDirectories(location.getParent(), new FileAttribute[0]);
        });
        KeyStoreCredentialStore credentialStore = new KeyStoreCredentialStore();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("location", location.toString());
        map.put("create", "true");
        try {
            credentialStore.initialize(map, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])secret.toCharArray())))), null);
            return credentialStore;
        }
        catch (CredentialStoreException e) {
            throw new RuntimeException(e);
        }
    }

    static void createCredentialStore(Path location, String secret) {
        KeyStoreCredentialStore credentialStore = ServerConfigurationParserTest.newCredentialStore(location, secret);
        ServerConfigurationParserTest.addCredential(credentialStore, "ldap", "strongPassword");
        ServerConfigurationParserTest.addCredential(credentialStore, "db", "test");
        ServerConfigurationParserTest.addCredential(credentialStore, "keystore", "password");
        ServerConfigurationParserTest.addCredential(credentialStore, "oauth2", "1fdca4ec-c416-47e0-867a-3d471af7050f");
        ServerConfigurationParserTest.addCredential(credentialStore, "trust", "secret");
    }
}

