/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.List;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.LdapIdentityMappingConfiguration;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.server.NameRewriter;

public class LdapRealmConfiguration
extends ConfigurationElement<LdapRealmConfiguration> {
    static final AttributeDefinition<char[]> CREDENTIAL = AttributeDefinition.builder((Enum)Attribute.CREDENTIAL, null, char[].class).serializer(AttributeSerializer.SECRET).build();
    static final AttributeDefinition<Boolean> DIRECT_EVIDENCE_VERIFICATION = AttributeDefinition.builder((Enum)Attribute.DIRECT_VERIFICATION, null, Boolean.class).build();
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, null, String.class).build();
    static final AttributeDefinition<NameRewriter> NAME_REWRITER = AttributeDefinition.builder((Enum)Element.NAME_REWRITER, null, NameRewriter.class).autoPersist(false).build();
    static final AttributeDefinition<String> PRINCIPAL = AttributeDefinition.builder((Enum)Attribute.PRINCIPAL, null, String.class).build();
    static final AttributeDefinition<Integer> PAGE_SIZE = AttributeDefinition.builder((Enum)Attribute.PAGE_SIZE, (Object)50, Integer.class).build();
    static final AttributeDefinition<String> RDN_IDENTIFIER = AttributeDefinition.builder((Enum)Attribute.RDN_IDENTIFIER, null, String.class).build();
    static final AttributeDefinition<String> SEARCH_DN = AttributeDefinition.builder((Enum)Attribute.SEARCH_DN, null, String.class).build();
    static final AttributeDefinition<String> URL = AttributeDefinition.builder((Enum)Attribute.URL, null, String.class).build();
    static final AttributeDefinition<Integer> CONNECTION_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.CONNECTION_TIMEOUT, (Object)5000, Integer.class).build();
    static final AttributeDefinition<Integer> READ_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.READ_TIMEOUT, (Object)60000, Integer.class).build();
    static final AttributeDefinition<Boolean> CONNECTION_POOLING = AttributeDefinition.builder((Enum)Attribute.CONNECTION_POOLING, (Object)false, Boolean.class).build();
    static final AttributeDefinition<DirContextFactory.ReferralMode> REFERRAL_MODE = AttributeDefinition.builder((Enum)Attribute.REFERRAL_MODE, (Object)DirContextFactory.ReferralMode.IGNORE, DirContextFactory.ReferralMode.class).build();
    private final List<LdapIdentityMappingConfiguration> identityMappings;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(LdapRealmConfiguration.class, new AttributeDefinition[]{CREDENTIAL, DIRECT_EVIDENCE_VERIFICATION, NAME, NAME_REWRITER, PRINCIPAL, PAGE_SIZE, RDN_IDENTIFIER, SEARCH_DN, URL, CONNECTION_TIMEOUT, READ_TIMEOUT, CONNECTION_POOLING, REFERRAL_MODE});
    }

    LdapRealmConfiguration(AttributeSet attributes, List<LdapIdentityMappingConfiguration> identityMappings) {
        super((Enum)Element.LDAP_REALM, attributes, new ConfigurationElement[0]);
        this.identityMappings = identityMappings;
    }

    public List<LdapIdentityMappingConfiguration> identityMappings() {
        return this.identityMappings;
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public NameRewriter nameRewriter() {
        return (NameRewriter)this.attributes.attribute(NAME_REWRITER).get();
    }
}

