/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmsConfiguration;
import org.infinispan.server.security.ServerSecurityRealm;

public class RealmsConfigurationBuilder
implements Builder<RealmsConfiguration> {
    private final Map<String, RealmConfigurationBuilder> securityRealms = new LinkedHashMap<String, RealmConfigurationBuilder>(2);

    public RealmConfigurationBuilder addSecurityRealm(String name) {
        RealmConfigurationBuilder realmConfigurationBuilder = new RealmConfigurationBuilder(name, this);
        this.securityRealms.put(name, realmConfigurationBuilder);
        return realmConfigurationBuilder;
    }

    public ServerSecurityRealm getServerSecurityRealm(String name) {
        RealmConfigurationBuilder builder = this.securityRealms.get(name);
        return builder.getServerSecurityRealm();
    }

    public SSLContext getSSLContext(String name) {
        RealmConfigurationBuilder realmConfigurationBuilder = this.securityRealms.get(name);
        if (realmConfigurationBuilder == null) {
            throw Server.log.unknownSecurityDomain(name);
        }
        return realmConfigurationBuilder.getSSLContext();
    }

    public RealmsConfiguration create() {
        List<RealmConfiguration> realms = this.securityRealms.values().stream().map(RealmConfigurationBuilder::create).collect(Collectors.toList());
        return new RealmsConfiguration(realms);
    }

    public RealmsConfigurationBuilder read(RealmsConfiguration template) {
        this.securityRealms.clear();
        template.realms().forEach(r -> this.addSecurityRealm(r.name()).read((RealmConfiguration)((Object)r)));
        return this;
    }

    public void validate() {
        this.securityRealms.values().forEach(RealmConfigurationBuilder::validate);
    }
}

