/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.CredentialStoreConfiguration;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.interfaces.ClearPassword;

public class CredentialStoresConfiguration
extends ConfigurationElement<CredentialStoresConfiguration> {
    private final Map<String, CredentialStoreConfiguration> credentialStores;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(CredentialStoresConfiguration.class, new AttributeDefinition[0]);
    }

    CredentialStoresConfiguration(AttributeSet attributes, Map<String, CredentialStoreConfiguration> credentialStores, Properties properties) {
        super((Enum)Element.CREDENTIAL_STORES, attributes, new ConfigurationElement[0]);
        attributes.checkProtection();
        this.credentialStores = credentialStores;
        this.init(properties);
    }

    public Map<String, CredentialStoreConfiguration> credentialStores() {
        return this.credentialStores;
    }

    public char[] getCredential(String store, String alias) {
        return ((ClearPassword)this.getCredential(store, alias, PasswordCredential.class).getPassword(ClearPassword.class)).getPassword();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <C extends Credential> C getCredential(String store, String alias, Class<C> type) {
        CredentialStoreConfiguration credentialStoreConfiguration;
        if (store == null) {
            if (this.credentialStores.size() != 1) throw Server.log.missingCredentialStoreName();
            credentialStoreConfiguration = this.credentialStores.values().iterator().next();
        } else {
            credentialStoreConfiguration = this.credentialStores.get(store);
        }
        if (credentialStoreConfiguration == null) {
            throw Server.log.unknownCredentialStore(store);
        }
        C credential = credentialStoreConfiguration.getCredential(alias, type);
        if (credential != null) return credential;
        throw Server.log.unknownCredential(alias, store);
    }

    private void init(Properties properties) {
        for (CredentialStoreConfiguration cs : this.credentialStores.values()) {
            cs.init(properties);
        }
    }
}

