/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.test.junit.JUnitThreadTrackerRule;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.configuration.InterfaceConfiguration;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.SocketBindingConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointConfiguration;
import org.infinispan.server.configuration.security.LdapRealmConfiguration;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmProvider;
import org.infinispan.server.configuration.security.TokenRealmConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.infinispan.server.security.ElytronPasswordProviderSupplier;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.WildFlyElytronCredentialStoreProvider;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

@RunWith(value=Parameterized.class)
public class ServerConfigurationParserTest {
    @ClassRule
    public static final JUnitThreadTrackerRule tracker = new JUnitThreadTrackerRule();
    private final MediaType type;

    @BeforeClass
    public static void setup() {
        ServerConfigurationParserTest.registerSecurityProviders();
        ServerConfigurationParserTest.createCredentialStore(ServerConfigurationParserTest.getConfigPath().resolve("credentials.pfx"), "secret");
    }

    @Parameterized.Parameters(name="{0}")
    public static Iterable<MediaType> data() {
        return Arrays.asList(MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_YAML);
    }

    public ServerConfigurationParserTest(MediaType type) {
        this.type = type;
    }

    @Test
    public void testParser() throws IOException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        URL url = fileLookup.lookupFileLocation("configuration/" + this.getClass().getSimpleName() + "." + this.type.getSubType().toLowerCase(Locale.ROOT), ServerConfigurationParserTest.class.getClassLoader());
        Properties properties = new Properties();
        properties.setProperty("infinispan.server.config.path", ServerConfigurationParserTest.getConfigPath().toString());
        properties.setProperty("infinispan.server.home.path", Paths.get(System.getProperty("build.directory"), new String[0]).toString());
        ParserRegistry registry = new ParserRegistry(this.getClass().getClassLoader(), false, properties);
        ConfigurationBuilderHolder holder = registry.parse(url);
        GlobalConfiguration global = holder.getGlobalConfigurationBuilder().build();
        ServerConfiguration serverConfiguration = (ServerConfiguration)global.module(ServerConfiguration.class);
        this.validateConfiguration(serverConfiguration);
    }

    private void validateConfiguration(ServerConfiguration configuration) {
        Assert.assertEquals((long)2L, (long)configuration.networkInterfaces().size());
        NetworkAddress defaultInterface = ((InterfaceConfiguration)configuration.networkInterfaces().get("default")).getNetworkAddress();
        Assert.assertNotNull((Object)defaultInterface);
        Assert.assertTrue((boolean)defaultInterface.getAddress().isLoopbackAddress());
        Map socketBindings = configuration.socketBindings();
        Assert.assertEquals((long)5L, (long)socketBindings.size());
        Assert.assertEquals((long)11221L, (long)((SocketBindingConfiguration)socketBindings.get("memcached")).port());
        Assert.assertEquals((long)12221L, (long)((SocketBindingConfiguration)socketBindings.get("memcached-2")).port());
        Assert.assertEquals((long)11222L, (long)((SocketBindingConfiguration)socketBindings.get("default")).port());
        Assert.assertEquals((long)11223L, (long)((SocketBindingConfiguration)socketBindings.get("hotrod")).port());
        Assert.assertEquals((long)8080L, (long)((SocketBindingConfiguration)socketBindings.get("rest")).port());
        Map realms = configuration.security().realms().realms();
        Assert.assertEquals((long)3L, (long)realms.size());
        RealmConfiguration realmConfiguration = (RealmConfiguration)realms.get("default");
        Assert.assertEquals((Object)"default", (Object)realmConfiguration.name());
        realmConfiguration = (RealmConfiguration)realms.get("using-credentials");
        Assert.assertEquals((Object)"using-credentials", (Object)realmConfiguration.name());
        Map dataSources = configuration.dataSources();
        Assert.assertEquals((long)2L, (long)dataSources.size());
        DataSourceConfiguration dataSource = (DataSourceConfiguration)dataSources.get("database");
        Assert.assertEquals((Object)"jdbc/database", (Object)dataSource.jndiName());
        Assert.assertEquals((Object)"jdbc:h2:tcp://${org.infinispan.test.host.address}:1521/test", (Object)dataSource.url());
        Assert.assertEquals((Object)"test", (Object)dataSource.username());
        Assert.assertEquals((Object)"test", (Object)new String(dataSource.password()));
        Assert.assertEquals((Object)"SELECT 1", (Object)dataSource.initialSql());
        Assert.assertEquals((Object)"org.h2.Driver", (Object)dataSource.driver());
        Assert.assertEquals((long)10L, (long)dataSource.maxSize());
        Assert.assertEquals((long)1L, (long)dataSource.minSize());
        Assert.assertEquals((long)1L, (long)dataSource.initialSize());
        Assert.assertEquals((long)1L, (long)dataSource.connectionProperties().size());
        Assert.assertEquals((long)10000L, (long)dataSource.leakDetection());
        Assert.assertEquals((long)1000L, (long)dataSource.backgroundValidation());
        Assert.assertEquals((long)500L, (long)dataSource.validateOnAcquisition());
        Assert.assertEquals((Object)"somevalue", dataSource.connectionProperties().get("someproperty"));
        dataSource = (DataSourceConfiguration)dataSources.get("database-with-credential");
        Assert.assertEquals((Object)"test", (Object)new String(dataSource.password()));
        List connectors = ((EndpointConfiguration)configuration.endpoints().endpoints().get(0)).connectors();
        Assert.assertEquals((long)3L, (long)connectors.size());
        Assert.assertTrue((boolean)(connectors.get(0) instanceof HotRodServerConfiguration));
        Assert.assertTrue((boolean)(connectors.get(1) instanceof RestServerConfiguration));
        Assert.assertTrue((boolean)(connectors.get(2) instanceof MemcachedServerConfiguration));
        SinglePortRouterConfiguration singlePortRouter = ((EndpointConfiguration)configuration.endpoints().endpoints().get(0)).singlePortRouter();
        Assert.assertEquals((Object)((SocketBindingConfiguration)socketBindings.get("default")).interfaceConfiguration().getNetworkAddress().getAddress().getHostAddress(), (Object)singlePortRouter.host());
        Assert.assertEquals((long)((SocketBindingConfiguration)socketBindings.get("default")).port(), (long)singlePortRouter.port());
        Assert.assertEquals((long)((SocketBindingConfiguration)socketBindings.get("memcached")).port(), (long)((ProtocolServerConfiguration)((EndpointConfiguration)configuration.endpoints().endpoints().get(0)).connectors().get(2)).port());
        Assert.assertEquals((Object)"strongPassword", (Object)new String((char[])((Supplier)this.realmProvider(realmConfiguration, LdapRealmConfiguration.class).attributes().attribute((Enum)Attribute.CREDENTIAL).get()).get()));
        Assert.assertEquals((Object)"secret", (Object)new String((char[])((Supplier)realmConfiguration.serverIdentitiesConfiguration().sslConfiguration().trustStore().attributes().attribute((Enum)Attribute.PASSWORD).get()).get()));
        Assert.assertEquals((Object)"1fdca4ec-c416-47e0-867a-3d471af7050f", (Object)new String((char[])((Supplier)this.realmProvider(realmConfiguration, TokenRealmConfiguration.class).oauth2Configuration().attributes().attribute((Enum)Attribute.CLIENT_SECRET).get()).get()));
    }

    <T extends RealmProvider> T realmProvider(RealmConfiguration realm, Class<T> providerClass) {
        return (T)realm.realmProviders().stream().filter(r -> providerClass.isAssignableFrom(r.getClass())).findFirst().get();
    }

    public static Path getConfigPath() {
        return Paths.get(System.getProperty("build.directory"), "test-classes", "configuration");
    }

    public static void registerSecurityProviders() {
        WildFlyElytronCredentialStoreProvider provider = WildFlyElytronCredentialStoreProvider.getInstance();
        if (Security.getProvider(provider.getName()) == null) {
            Security.insertProviderAt((Provider)provider, 1);
        }
    }

    static void addCredential(KeyStoreCredentialStore store, String alias, String credential) {
        try {
            store.store(alias, (Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])credential.toCharArray())), null);
            store.flush();
        }
        catch (CredentialStoreException e) {
            throw new RuntimeException(e);
        }
    }

    static KeyStoreCredentialStore newCredentialStore(Path location, String secret) {
        Exceptions.unchecked(() -> {
            Files.deleteIfExists(location);
            Files.createDirectories(location.getParent(), new FileAttribute[0]);
        });
        KeyStoreCredentialStore credentialStore = new KeyStoreCredentialStore();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("location", location.toString());
        map.put("create", "true");
        try {
            credentialStore.initialize(map, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])secret.toCharArray())))), ElytronPasswordProviderSupplier.PROVIDERS);
            return credentialStore;
        }
        catch (CredentialStoreException e) {
            throw new RuntimeException(e);
        }
    }

    static void createCredentialStore(Path location, String secret) {
        KeyStoreCredentialStore credentialStore = ServerConfigurationParserTest.newCredentialStore(location, secret);
        ServerConfigurationParserTest.addCredential(credentialStore, "ldap", "strongPassword");
        ServerConfigurationParserTest.addCredential(credentialStore, "db", "test");
        ServerConfigurationParserTest.addCredential(credentialStore, "keystore", "password");
        ServerConfigurationParserTest.addCredential(credentialStore, "oauth2", "1fdca4ec-c416-47e0-867a-3d471af7050f");
        ServerConfigurationParserTest.addCredential(credentialStore, "trust", "secret");
    }
}

