/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.io.IOException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.AddressConfigurationBuilder;
import org.infinispan.server.configuration.AddressType;
import org.infinispan.server.configuration.InterfaceConfiguration;
import org.infinispan.server.network.NetworkAddress;

public class InterfaceConfigurationBuilder
implements Builder<InterfaceConfiguration> {
    private final AttributeSet attributes;
    private final AddressConfigurationBuilder address = new AddressConfigurationBuilder();
    private NetworkAddress networkAddress;

    InterfaceConfigurationBuilder(String name) {
        this.attributes = InterfaceConfiguration.attributeDefinitionSet();
        this.attributes.attribute(InterfaceConfiguration.NAME).set((Object)name);
    }

    public InterfaceConfigurationBuilder address(AddressType addressType, String addressValue) throws IOException {
        this.address.type(addressType, addressValue);
        this.networkAddress = this.createNetworkAddress();
        return this;
    }

    NetworkAddress networkAddress() {
        return this.networkAddress;
    }

    public String name() {
        return (String)this.attributes.attribute(InterfaceConfiguration.NAME).get();
    }

    private NetworkAddress createNetworkAddress() throws IOException {
        String interfaceName = this.name();
        AddressType addressType = this.address.addressType();
        String addressValue = this.address.value();
        switch (addressType) {
            case ANY_ADDRESS: {
                return NetworkAddress.anyAddress(interfaceName);
            }
            case INET_ADDRESS: {
                return NetworkAddress.fromString(interfaceName, addressValue);
            }
            case LINK_LOCAL: {
                return NetworkAddress.linkLocalAddress(interfaceName);
            }
            case GLOBAL: {
                return NetworkAddress.globalAddress(interfaceName);
            }
            case LOOPBACK: {
                return NetworkAddress.loopback(interfaceName);
            }
            case NON_LOOPBACK: {
                return NetworkAddress.nonLoopback(interfaceName);
            }
            case SITE_LOCAL: {
                return NetworkAddress.siteLocal(interfaceName);
            }
            case MATCH_INTERFACE: {
                return NetworkAddress.matchInterface(interfaceName, addressValue);
            }
            case MATCH_ADDRESS: {
                return NetworkAddress.matchAddress(interfaceName, addressValue);
            }
            case MATCH_HOST: {
                return NetworkAddress.matchHost(interfaceName, addressValue);
            }
        }
        return null;
    }

    public InterfaceConfiguration create() {
        return new InterfaceConfiguration(this.attributes.protect(), this.address.create(), this.networkAddress);
    }

    public InterfaceConfigurationBuilder read(InterfaceConfiguration template) {
        this.attributes.read(template.attributes());
        this.address.read(template.addressConfiguration());
        return this;
    }
}

