/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.DistributedRealmConfiguration;
import org.infinispan.server.configuration.security.GroupsPropertiesConfigurationBuilder;
import org.infinispan.server.configuration.security.PropertiesRealmConfiguration;
import org.infinispan.server.configuration.security.RealmProviderBuilder;
import org.infinispan.server.configuration.security.UserPropertiesConfigurationBuilder;

public class PropertiesRealmConfigurationBuilder
implements RealmProviderBuilder<PropertiesRealmConfiguration> {
    private final UserPropertiesConfigurationBuilder userProperties = new UserPropertiesConfigurationBuilder();
    private final GroupsPropertiesConfigurationBuilder groupProperties = new GroupsPropertiesConfigurationBuilder();
    private final AttributeSet attributes = PropertiesRealmConfiguration.attributeDefinitionSet();

    PropertiesRealmConfigurationBuilder() {
    }

    public PropertiesRealmConfigurationBuilder name(String name) {
        this.attributes.attribute(PropertiesRealmConfiguration.NAME).set((Object)name);
        return this;
    }

    @Override
    public String name() {
        return (String)this.attributes.attribute(DistributedRealmConfiguration.NAME).get();
    }

    public PropertiesRealmConfigurationBuilder groupAttribute(String groupAttribute) {
        this.attributes.attribute(PropertiesRealmConfiguration.GROUPS_ATTRIBUTE).set((Object)groupAttribute);
        return this;
    }

    public UserPropertiesConfigurationBuilder userProperties() {
        return this.userProperties;
    }

    public GroupsPropertiesConfigurationBuilder groupProperties() {
        return this.groupProperties;
    }

    public void validate() {
        this.userProperties.validate();
        this.groupProperties.validate();
    }

    public PropertiesRealmConfiguration create() {
        return new PropertiesRealmConfiguration(this.attributes.protect(), this.userProperties.create(), this.groupProperties.create());
    }

    public PropertiesRealmConfigurationBuilder read(PropertiesRealmConfiguration template) {
        this.attributes.read(template.attributes());
        this.userProperties.read(template.userProperties());
        this.groupProperties.read(template.groupProperties());
        return this;
    }

    @Override
    public int compareTo(RealmProviderBuilder o) {
        return 0;
    }
}

