/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.endpoint;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingsConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointConfigurationBuilder;
import org.infinispan.server.configuration.endpoint.EndpointsConfiguration;
import org.infinispan.server.configuration.security.SecurityConfiguration;

public class EndpointsConfigurationBuilder
implements Builder<EndpointsConfiguration> {
    private final AttributeSet attributes;
    private final ServerConfigurationBuilder server;
    private final Map<String, EndpointConfigurationBuilder> endpoints = new LinkedHashMap<String, EndpointConfigurationBuilder>(2);
    private EndpointConfigurationBuilder current;

    public EndpointsConfigurationBuilder(ServerConfigurationBuilder server) {
        this.server = server;
        this.attributes = EndpointsConfiguration.attributeDefinitionSet();
    }

    public EndpointConfigurationBuilder addEndpoint(String socketBindingName) {
        if (this.endpoints.containsKey(socketBindingName)) {
            throw Server.log.endpointSocketBindingConflict(socketBindingName);
        }
        EndpointConfigurationBuilder builder = new EndpointConfigurationBuilder(this.server, socketBindingName);
        this.endpoints.put(socketBindingName, builder);
        this.current = builder;
        return builder;
    }

    public EndpointConfigurationBuilder current() {
        return this.current;
    }

    public Map<String, EndpointConfigurationBuilder> endpoints() {
        return this.endpoints;
    }

    public EndpointsConfiguration create() {
        throw new UnsupportedOperationException();
    }

    public EndpointsConfiguration create(SocketBindingsConfiguration bindingsConfiguration, SecurityConfiguration securityConfiguration) {
        List<EndpointConfiguration> list = this.endpoints.values().stream().map(e -> e.create(bindingsConfiguration, securityConfiguration)).collect(Collectors.toList());
        return new EndpointsConfiguration(this.attributes.protect(), list);
    }

    public EndpointsConfigurationBuilder read(EndpointsConfiguration template) {
        this.attributes.read(template.attributes());
        this.endpoints.clear();
        return this;
    }
}

