/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.ServerConfigurationParserTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ServerConfigurationSerializerTest {
    static final List<MediaType> types = Arrays.asList(MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_YAML);
    static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Path config;
    private final MediaType type;

    @Parameterized.Parameters(name="{0} > [{2}]")
    public static Iterable<Object[]> data() throws IOException {
        Path configDir = Paths.get(System.getProperty("build.directory"), "test-classes", "configuration", "versions");
        ServerConfigurationParserTest.createCredentialStore(configDir.getParent().resolve("credentials.pfx"), "secret");
        return Files.list(configDir).flatMap(p -> types.stream().map(t -> new Object[]{p.getFileName(), p, t})).collect(Collectors.toList());
    }

    public ServerConfigurationSerializerTest(Path name, Path config, MediaType type) {
        this.config = config;
        this.type = type;
    }

    @Test
    public void testConfigurationSerialization() throws IOException {
        Properties properties = new Properties();
        properties.put("infinispan.server.config.path", this.config.getParent().getParent().toString());
        properties.setProperty("infinispan.server.home.path", Paths.get(System.getProperty("build.directory"), new String[0]).toString());
        ParserRegistry registry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), false, properties);
        ConfigurationBuilderHolder holderBefore = registry.parse(this.config);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HashMap<String, Configuration> configurations = new HashMap<String, Configuration>();
        for (Map.Entry configuration : holderBefore.getNamedConfigurationBuilders().entrySet()) {
            configurations.put((String)configuration.getKey(), ((ConfigurationBuilder)configuration.getValue()).build());
        }
        try (ConfigurationWriter writer = ConfigurationWriter.to((OutputStream)baos).withType(this.type).clearTextSecrets(true).build();){
            registry.serialize(writer, holderBefore.getGlobalConfigurationBuilder().build(), configurations);
        }
        log.debug((Object)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ConfigurationBuilderHolder holderAfter = registry.parse((InputStream)bais, null, this.type);
        GlobalConfiguration globalConfigurationBefore = holderBefore.getGlobalConfigurationBuilder().build();
        GlobalConfiguration globalConfigurationAfter = holderAfter.getGlobalConfigurationBuilder().build();
        ServerConfiguration serverBefore = (ServerConfiguration)globalConfigurationBefore.module(ServerConfiguration.class);
        ServerConfiguration serverAfter = (ServerConfiguration)globalConfigurationAfter.module(ServerConfiguration.class);
        this.compare(serverBefore.interfaces.interfaces(), serverAfter.interfaces.interfaces());
        ServerConfigurationSerializerTest.compare(serverBefore.socketBindings, serverAfter.socketBindings, new String[0]);
        ServerConfigurationSerializerTest.compare(serverBefore.dataSources, serverAfter.dataSources, new String[0]);
        ServerConfigurationSerializerTest.compare(serverBefore.security.credentialStores(), serverAfter.security.credentialStores(), new String[0]);
        this.compare(serverBefore.security.realms().realms(), serverAfter.security.realms().realms());
        ServerConfigurationSerializerTest.compare(serverBefore.security.transport(), serverAfter.security.transport(), new String[]{Attribute.SECURITY_REALM.toString()});
        this.compare(serverBefore.endpoints.endpoints(), serverAfter.endpoints.endpoints());
    }

    <T extends ConfigurationElement> void compare(List<T> before, List<T> after) {
        Assert.assertEquals((long)before.size(), (long)after.size());
        Iterator<T> b = before.iterator();
        Iterator<T> a = after.iterator();
        while (b.hasNext()) {
            ServerConfigurationSerializerTest.compare((ConfigurationElement)b.next(), (ConfigurationElement)a.next(), new String[0]);
        }
    }

    <T extends ConfigurationElement> void compare(Map<String, T> before, Map<String, T> after) {
        Assert.assertEquals((long)before.size(), (long)after.size());
        Iterator<T> b = before.values().iterator();
        Iterator<T> a = after.values().iterator();
        while (b.hasNext()) {
            ServerConfigurationSerializerTest.compare((ConfigurationElement)b.next(), (ConfigurationElement)a.next(), new String[0]);
        }
    }

    static void compare(ConfigurationElement<?> before, ConfigurationElement<?> after, String ... exclude) {
        Assert.assertEquals((Object)before.elementName(), (Object)after.elementName());
        ServerConfigurationSerializerTest.compare(before.elementName(), before.attributes(), after.attributes(), exclude);
        Assert.assertEquals((long)before.children().length, (long)after.children().length);
        for (int i = 0; i < before.children().length; ++i) {
            ServerConfigurationSerializerTest.compare(before.children()[i], after.children()[i], new String[0]);
        }
    }

    static void compare(String name, AttributeSet before, AttributeSet after, String ... exclude) {
        if (before != null && after != null) {
            List<Object> exclusions = exclude != null ? Arrays.asList(exclude) : Collections.emptyList();
            for (org.infinispan.commons.configuration.attributes.Attribute attribute : before.attributes()) {
                if (exclusions.contains(attribute.name())) continue;
                Assert.assertEquals((String)("Configuration " + name), (Object)attribute, (Object)after.attribute(attribute.name()));
            }
        }
    }
}

