/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.junit.JUnitThreadTrackerRule;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.configuration.AbstractConfigurationParserTest;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.configuration.InterfaceConfiguration;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.SocketBindingConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointConfiguration;
import org.infinispan.server.configuration.security.CredentialStoresConfiguration;
import org.infinispan.server.configuration.security.LdapRealmConfiguration;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmProvider;
import org.infinispan.server.configuration.security.TokenRealmConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class ServerConfigurationParserTest
extends AbstractConfigurationParserTest {
    @ClassRule
    public static final JUnitThreadTrackerRule tracker = new JUnitThreadTrackerRule();

    public ServerConfigurationParserTest(MediaType type) {
        super(type);
    }

    @Override
    public String path() {
        return "configuration/" + this.getClass().getSimpleName() + "." + this.type.getSubType().toLowerCase(Locale.ROOT);
    }

    @Test
    public void testParser() throws IOException {
        ServerConfiguration serverConfiguration = this.loadAndParseConfiguration();
        this.validateConfiguration(serverConfiguration);
    }

    private void validateConfiguration(ServerConfiguration configuration) {
        Assert.assertEquals((long)2L, (long)configuration.networkInterfaces().size());
        NetworkAddress defaultInterface = ((InterfaceConfiguration)configuration.networkInterfaces().get("default")).getNetworkAddress();
        Assert.assertNotNull((Object)defaultInterface);
        Assert.assertTrue((boolean)defaultInterface.getAddress().isLoopbackAddress());
        Map socketBindings = configuration.socketBindings();
        Assert.assertEquals((long)5L, (long)socketBindings.size());
        Assert.assertEquals((long)11221L, (long)((SocketBindingConfiguration)socketBindings.get("memcached")).port());
        Assert.assertEquals((long)12221L, (long)((SocketBindingConfiguration)socketBindings.get("memcached-2")).port());
        Assert.assertEquals((long)11222L, (long)((SocketBindingConfiguration)socketBindings.get("default")).port());
        Assert.assertEquals((long)11223L, (long)((SocketBindingConfiguration)socketBindings.get("hotrod")).port());
        Assert.assertEquals((long)8080L, (long)((SocketBindingConfiguration)socketBindings.get("rest")).port());
        Map realms = configuration.security().realms().realms();
        Assert.assertEquals((long)3L, (long)realms.size());
        RealmConfiguration realmConfiguration = (RealmConfiguration)realms.get("default");
        Assert.assertEquals((Object)"default", (Object)realmConfiguration.name());
        realmConfiguration = (RealmConfiguration)realms.get("using-credentials");
        Assert.assertEquals((Object)"using-credentials", (Object)realmConfiguration.name());
        Map dataSources = configuration.dataSources();
        Assert.assertEquals((long)2L, (long)dataSources.size());
        DataSourceConfiguration dataSource = (DataSourceConfiguration)dataSources.get("database");
        Assert.assertEquals((Object)"jdbc/database", (Object)dataSource.jndiName());
        Assert.assertEquals((Object)"jdbc:h2:tcp://${org.infinispan.test.host.address}:1521/test", (Object)dataSource.url());
        Assert.assertEquals((Object)"test", (Object)dataSource.username());
        Assert.assertEquals((Object)"test", (Object)new String(dataSource.password()));
        Assert.assertEquals((Object)"SELECT 1", (Object)dataSource.initialSql());
        Assert.assertEquals((Object)"org.h2.Driver", (Object)dataSource.driver());
        Assert.assertEquals((long)10L, (long)dataSource.maxSize());
        Assert.assertEquals((long)1L, (long)dataSource.minSize());
        Assert.assertEquals((long)1L, (long)dataSource.initialSize());
        Assert.assertEquals((long)1L, (long)dataSource.connectionProperties().size());
        Assert.assertEquals((long)10000L, (long)dataSource.leakDetection());
        Assert.assertEquals((long)1000L, (long)dataSource.backgroundValidation());
        Assert.assertEquals((long)500L, (long)dataSource.validateOnAcquisition());
        Assert.assertEquals((Object)"somevalue", dataSource.connectionProperties().get("someproperty"));
        dataSource = (DataSourceConfiguration)dataSources.get("database-with-credential");
        Assert.assertEquals((Object)"test", (Object)new String(dataSource.password()));
        List connectors = ((EndpointConfiguration)configuration.endpoints().endpoints().get(0)).connectors();
        Assert.assertEquals((long)3L, (long)connectors.size());
        Assert.assertTrue((boolean)(connectors.get(0) instanceof HotRodServerConfiguration));
        Assert.assertTrue((boolean)(connectors.get(1) instanceof RestServerConfiguration));
        Assert.assertTrue((boolean)(connectors.get(2) instanceof MemcachedServerConfiguration));
        SinglePortRouterConfiguration singlePortRouter = ((EndpointConfiguration)configuration.endpoints().endpoints().get(0)).singlePortRouter();
        Assert.assertEquals((Object)((SocketBindingConfiguration)socketBindings.get("default")).interfaceConfiguration().getNetworkAddress().getAddress().getHostAddress(), (Object)singlePortRouter.host());
        Assert.assertEquals((long)((SocketBindingConfiguration)socketBindings.get("default")).port(), (long)singlePortRouter.port());
        Assert.assertEquals((long)((SocketBindingConfiguration)socketBindings.get("memcached")).port(), (long)((ProtocolServerConfiguration)((EndpointConfiguration)configuration.endpoints().endpoints().get(0)).connectors().get(2)).port());
        Assert.assertEquals((Object)"strongPassword", (Object)new String(CredentialStoresConfiguration.resolvePassword((org.infinispan.commons.configuration.attributes.Attribute)this.realmProvider(realmConfiguration, LdapRealmConfiguration.class).attributes().attribute((Enum)Attribute.CREDENTIAL))));
        Assert.assertEquals((Object)"secret", (Object)new String(CredentialStoresConfiguration.resolvePassword((org.infinispan.commons.configuration.attributes.Attribute)realmConfiguration.serverIdentitiesConfiguration().sslConfiguration().trustStore().attributes().attribute((Enum)Attribute.PASSWORD))));
        Assert.assertEquals((Object)"1fdca4ec-c416-47e0-867a-3d471af7050f", (Object)new String(CredentialStoresConfiguration.resolvePassword((org.infinispan.commons.configuration.attributes.Attribute)this.realmProvider(realmConfiguration, TokenRealmConfiguration.class).oauth2Configuration().attributes().attribute((Enum)Attribute.CLIENT_SECRET))));
        Assert.assertEquals((long)3L, (long)configuration.security.credentialStores().credentialStores().size());
    }

    <T extends RealmProvider> T realmProvider(RealmConfiguration realm, Class<T> providerClass) {
        return (T)realm.realmProviders().stream().filter(r -> providerClass.isAssignableFrom(r.getClass())).findFirst().get();
    }
}

