/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.Locale;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.junit.JUnitThreadTrackerRule;
import org.infinispan.server.configuration.AbstractConfigurationParserTest;
import org.infinispan.server.configuration.ServerConfigurationParserTest;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class KeyStoreConfigurationTest
extends AbstractConfigurationParserTest {
    @ClassRule
    public static final JUnitThreadTrackerRule tracker = new JUnitThreadTrackerRule();

    public KeyStoreConfigurationTest(MediaType type) {
        super(type);
    }

    @Override
    public String path() {
        return "configuration/invalid-alias/KeystoreInvalidAlias." + this.type.getSubType().toLowerCase(Locale.ROOT);
    }

    @Test
    public void shouldThrowOnInvalidAlias() {
        CacheConfigurationException e = (CacheConfigurationException)Assert.assertThrows(CacheConfigurationException.class, this::loadAndParseConfiguration);
        Assert.assertTrue((String)("Cause is: " + e.getCause()), (boolean)(e.getCause() instanceof CacheConfigurationException));
        Assert.assertEquals((Object)this.exceptionMessage(), (Object)e.getCause().getMessage());
    }

    private String exceptionMessage() {
        return String.format("ISPN080069: Alias 'definitely-an-unknown-alias' not in keystore '%s'", ServerConfigurationParserTest.pathToKeystore());
    }
}

