/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.persistence;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.junit.JUnitThreadTrackerRule;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class EventLoggerCompatibilityTest {
    @ClassRule
    public static final JUnitThreadTrackerRule tracker = new JUnitThreadTrackerRule();
    String tmpDirectory;

    @Before
    public void startup() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(this.getClass());
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    @After
    public void teardown() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    @Test
    public void testReadWriteFrom11EventCache() throws Exception {
        final String cacheName = "event-cache";
        String file = "sfs/11_0/event_log_cache.dat";
        InputStream is = FileLookupFactory.newInstance().lookupFile(file, Thread.currentThread().getContextClassLoader());
        File sfsFile = SingleFileStore.getStoreFile((String)this.tmpDirectory, (String)cacheName);
        if (!sfsFile.exists()) {
            sfsFile.getParentFile().mkdirs();
        }
        Files.copy(is, sfsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        final Configuration config = ((SingleFileStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addSingleFileStore().segmented(false)).location(this.tmpDirectory).build();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            public void call() {
                Cache cache = this.cm.createCache(cacheName, config);
                Assert.assertEquals((long)43L, (long)cache.size());
            }
        });
    }
}

