/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Properties;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.ServerConfigurationParserTest;
import org.junit.Assert;
import org.junit.Test;

public class ServerOverlayConfigurationTest {
    @Test
    public void testOverlay() {
        Properties properties = new Properties();
        properties.put("infinispan.server.config.path", ServerConfigurationParserTest.getConfigPath().toString());
        properties.put("infinispan.server.home.path", ServerConfigurationParserTest.getConfigPath().toString());
        Server server = new Server(ServerConfigurationParserTest.getConfigPath().toFile(), Arrays.asList(Paths.get("Base.xml", new String[0]), Paths.get("Overlay.yml", new String[0])), properties);
        ConfigurationBuilderHolder holder = server.getConfigurationBuilderHolder();
        Assert.assertTrue((boolean)holder.getNamedConfigurationBuilders().containsKey("overlay"));
        GlobalConfiguration global = holder.getGlobalConfigurationBuilder().build();
        Assert.assertNotNull((Object)global.module(ServerConfiguration.class));
    }

    @Test
    public void testOverlayTwice() {
        Properties properties = new Properties();
        properties.put("infinispan.server.config.path", ServerConfigurationParserTest.getConfigPath().toString());
        Server server = new Server(ServerConfigurationParserTest.getConfigPath().toFile(), Arrays.asList(Paths.get("Base.xml", new String[0]), Paths.get("Overlay.yml", new String[0]), Paths.get("Overlay-AsyncReplicatedCache.yml", new String[0])), properties);
        ConfigurationBuilderHolder holder = server.getConfigurationBuilderHolder();
        Assert.assertTrue((boolean)holder.getNamedConfigurationBuilders().containsKey("secondary-cache"));
        Assert.assertFalse((boolean)holder.getGlobalConfigurationBuilder().cacheContainer().statistics());
        Assert.assertFalse((boolean)holder.getGlobalConfigurationBuilder().cacheContainer().jmx().enabled());
        GlobalConfiguration global = holder.getGlobalConfigurationBuilder().build();
        Assert.assertNotNull((Object)global.module(ServerConfiguration.class));
    }

    @Test
    public void testOverlayManyConfigurations() {
        Properties properties = new Properties();
        properties.put("infinispan.server.config.path", ServerConfigurationParserTest.getConfigPath().toString());
        Server server = new Server(ServerConfigurationParserTest.getConfigPath().toFile(), Arrays.asList(Paths.get("Base.xml", new String[0]), Paths.get("Overlay.yml", new String[0]), Paths.get("Overlay-AsyncReplicatedCache.yml", new String[0]), Paths.get("OverlayJmx.yml", new String[0]), Paths.get("OverlayMetrics.xml", new String[0])), properties);
        ConfigurationBuilderHolder holder = server.getConfigurationBuilderHolder();
        Assert.assertTrue((boolean)holder.getNamedConfigurationBuilders().containsKey("overlay"));
        Assert.assertTrue((boolean)holder.getNamedConfigurationBuilders().containsKey("secondary-cache"));
        GlobalConfiguration global = holder.getGlobalConfigurationBuilder().build();
        Assert.assertNotNull((Object)global.module(ServerConfiguration.class));
    }

    @Test
    public void testUnorderedOverlay() {
        Properties properties = new Properties();
        properties.put("infinispan.server.config.path", ServerConfigurationParserTest.getConfigPath().toString());
        Server server = new Server(ServerConfigurationParserTest.getConfigPath().toFile(), Arrays.asList(Paths.get("OverlayMetrics.xml", new String[0]), Paths.get("Overlay-AsyncReplicatedCache.yml", new String[0]), Paths.get("OverlayJmx.yml", new String[0]), Paths.get("Overlay.yml", new String[0]), Paths.get("Base.xml", new String[0])), properties);
        ConfigurationBuilderHolder holder = server.getConfigurationBuilderHolder();
        Assert.assertTrue((boolean)holder.getNamedConfigurationBuilders().containsKey("overlay"));
        Assert.assertTrue((boolean)holder.getNamedConfigurationBuilders().containsKey("secondary-cache"));
        Assert.assertTrue((boolean)holder.getGlobalConfigurationBuilder().cacheContainer().statistics());
        Assert.assertTrue((boolean)holder.getGlobalConfigurationBuilder().cacheContainer().jmx().enabled());
        GlobalConfiguration global = holder.getGlobalConfigurationBuilder().build();
        Assert.assertNotNull((Object)global.module(ServerConfiguration.class));
    }
}

