/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.license;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class LicenseTest {
    private static final Pattern TR_REGEX = Pattern.compile("<tr>(.+?)</tr>", 32);
    private static final Pattern TD_VALUE_REGEX = Pattern.compile("<td>(.*?)</td>", 32);
    private static final String SERVER_OUTPUT_PATH = System.getProperty("server.output.dir");

    @Test
    public void testLicense() throws IOException {
        Set libs = Files.list(this.getLibDir()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(String::valueOf).map(LicenseTest::removeOsName).collect(Collectors.toSet());
        String html = new String(Files.readAllBytes(this.getDependencyHtmlFile()));
        Matcher trMatcher = TR_REGEX.matcher(html);
        ArrayList<String> htmlDependencies = new ArrayList<String>();
        while (trMatcher.find()) {
            String artifact;
            String trValue = trMatcher.group(1);
            Matcher tdMatcher = TD_VALUE_REGEX.matcher(trValue);
            if (!tdMatcher.find()) continue;
            String group = tdMatcher.group(1);
            if (group.contains("@patternfly")) {
                String[] splitGroup = group.split("/");
                artifact = splitGroup[1];
                tdMatcher.find();
            } else {
                tdMatcher.find();
                artifact = tdMatcher.group(1);
            }
            tdMatcher.find();
            String version = tdMatcher.group(1);
            tdMatcher.find();
            String remoteLicenses = tdMatcher.group(1);
            Assert.assertTrue((String)("Remote License: " + artifact + ":" + version + ":" + remoteLicenses), (boolean)this.hasLicenseLink(remoteLicenses));
            tdMatcher.find();
            String localLicenses = tdMatcher.group(1);
            Assert.assertTrue((String)("Local License: " + artifact + ":" + version + ":" + localLicenses), (boolean)this.hasLicenseLink(localLicenses));
            htmlDependencies.add(String.format("%s-%s.jar", artifact, version));
        }
        libs.removeAll(htmlDependencies);
        for (String lib : libs) {
            System.out.println("Missing: " + lib);
        }
        Assert.assertEquals((String)libs.toString(), (long)0L, (long)libs.size());
    }

    private static String removeOsName(String jarFile) {
        return jarFile.replace("epoll-linux-x86_64", "epoll").replace("epoll-linux-aarch_64", "epoll").replace("io_uring-linux-x86_64", "io_uring").replace("io_uring-linux-aarch_64", "io_uring");
    }

    private Path getLibDir() {
        File libDir = new File(SERVER_OUTPUT_PATH, "lib");
        return libDir.toPath();
    }

    private Path getDependencyHtmlFile() {
        File docsDir = new File(SERVER_OUTPUT_PATH, "docs");
        File licensesDir = new File(docsDir, "licenses");
        File licensesHtmlFile = new File(licensesDir, "licenses.html");
        return licensesHtmlFile.toPath();
    }

    private boolean hasLicenseLink(String value) {
        return value != null && value.contains("a href");
    }
}

