/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import org.infinispan.Version;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.server.DefaultExitHandler;
import org.infinispan.server.server.ExitHandler;
import org.infinispan.server.server.SecurityActions;
import org.infinispan.server.server.configuration.ServerConfiguration;
import org.infinispan.server.server.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class Server {
    public static final Log log = (Log)LogFactory.getLog(Server.class, Log.class);
    public static final String INFINISPAN_BIND_ADDRESS = "infinispan.bind.address";
    public static final String INFINISPAN_NODE_NAME = "infinispan.node.name";
    public static final String INFINISPAN_PORT_OFFSET = "infinispan.socket.binding.port-offset";
    public static final String INFINISPAN_SERVER_ROOT = "infinispan.server.root";
    public static final String INFINISPAN_SERVER_HOME = "infinispan.server.home";
    public static final String INFINISPAN_SERVER_CONFIG = "infinispan.server.config";
    public static final String INFINISPAN_SERVER_DATA = "infinispan.server.data";
    public static final String INFINISPAN_SERVER_LOG = "infinispan.server.log";
    private static final String SERVER_DEFAULTS = "infinispan-defaults.xml";
    public static final String DEFAULT_SERVER_CONFIG = "conf";
    public static final String DEFAULT_SERVER_DATA = "data";
    public static final String DEFAULT_SERVER_LOG = "log";
    public static final String DEFAULT_SERVER_ROOT_DIR = "server";
    public static final String DEFAULT_CONFIGURATION_FILE = "infinispan.xml";
    private final TimeService timeService;
    private final File serverRoot;
    private final File serverConf;
    private final long startTime;
    private final Properties properties;
    private ExitHandler exitHandler = new DefaultExitHandler();
    private ConfigurationBuilderHolder defaultsHolder;
    private ConfigurationBuilderHolder configurationBuilderHolder;
    private Map<String, DefaultCacheManager> cacheManagers;
    private Map<String, ProtocolServer> protocolServers;
    private volatile boolean running = false;
    private ComponentStatus status;

    public Server() {
        this(new File(DEFAULT_SERVER_ROOT_DIR), new File(DEFAULT_CONFIGURATION_FILE), SecurityActions.getSystemProperties());
    }

    public Server(File serverRoot, File configuration, Properties properties) {
        this(serverRoot, properties);
        if (!configuration.isAbsolute()) {
            configuration = new File(this.serverConf, configuration.getPath());
        }
        try (FileInputStream is = new FileInputStream(configuration);){
            this.parseConfiguration(is);
        }
        catch (IOException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    private Server(File serverRoot, Properties properties) {
        this.timeService = DefaultTimeService.INSTANCE;
        this.startTime = this.timeService.time();
        this.serverRoot = serverRoot;
        this.properties = properties;
        this.status = ComponentStatus.INSTANTIATED;
        properties.putIfAbsent(INFINISPAN_SERVER_ROOT, serverRoot);
        properties.putIfAbsent(INFINISPAN_SERVER_CONFIG, new File(serverRoot, DEFAULT_SERVER_CONFIG).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_DATA, new File(serverRoot, DEFAULT_SERVER_DATA).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_LOG, new File(serverRoot, DEFAULT_SERVER_LOG).getAbsolutePath());
        this.serverConf = new File(properties.getProperty(INFINISPAN_SERVER_CONFIG));
    }

    private void parseConfiguration(InputStream config) {
        ParserRegistry parser = new ParserRegistry(this.getClass().getClassLoader(), false, this.properties);
        try (InputStream defaults = this.getClass().getClassLoader().getResourceAsStream(SERVER_DEFAULTS);){
            this.defaultsHolder = parser.parse(defaults);
            this.configurationBuilderHolder = new ConfigurationBuilderHolder();
            this.configurationBuilderHolder.getGlobalConfigurationBuilder().read(this.defaultsHolder.getGlobalConfigurationBuilder().build());
            this.configurationBuilderHolder = parser.parse(config, this.configurationBuilderHolder);
            for (Map.Entry entry : this.configurationBuilderHolder.getNamedConfigurationBuilders().entrySet()) {
                Configuration cfg = ((ConfigurationBuilder)entry.getValue()).build();
                ConfigurationBuilder defaultCfg = (ConfigurationBuilder)this.defaultsHolder.getNamedConfigurationBuilders().get(cfg.clustering().cacheMode().name());
                ConfigurationBuilder rebased = new ConfigurationBuilder().read(defaultCfg.build());
                rebased.read(cfg);
                entry.setValue(rebased);
            }
            this.configurationBuilderHolder.validate();
        }
        catch (IOException | XMLStreamException e) {
            throw new CacheConfigurationException(e);
        }
    }

    public ExitHandler getExitHandler() {
        return this.exitHandler;
    }

    public void setExitHandler(ExitHandler exitHandler) {
        if (this.running) {
            throw new IllegalStateException("Cannot change exit handler on a running server");
        }
        this.exitHandler = exitHandler;
    }

    public CompletableFuture<Integer> run() {
        CompletionStage<Integer> r = this.exitHandler.getExitFuture();
        this.cacheManagers = new LinkedHashMap<String, DefaultCacheManager>(1);
        this.protocolServers = new LinkedHashMap<String, ProtocolServer>(3);
        try {
            DefaultCacheManager cm = new DefaultCacheManager(this.configurationBuilderHolder, true);
            this.cacheManagers.put(cm.getName(), cm);
            ServerConfiguration serverConfiguration = (ServerConfiguration)cm.getCacheManagerConfiguration().module(ServerConfiguration.class);
            serverConfiguration.endpoints().parallelStream().forEach(configuration -> {
                Class<ProtocolServer> protocolServerClass = configuration.getClass().getAnnotation(ConfigurationFor.class).value().asSubclass(ProtocolServer.class);
                ProtocolServer protocolServer = (ProtocolServer)Util.getInstance(protocolServerClass);
                this.protocolServers.put(protocolServer.getName() + "-" + configuration.name(), protocolServer);
                protocolServer.start(configuration, (EmbeddedCacheManager)cm);
                ProtocolServerConfiguration protocolConfig = protocolServer.getConfiguration();
                log.protocolStarted(protocolServer.getName(), protocolConfig.host(), protocolConfig.port());
            });
            this.status = ComponentStatus.RUNNING;
            log.serverStarted(Version.getBrandName(), Version.getVersion(), this.timeService.timeDuration(this.startTime, TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            r.completeExceptionally(e);
        }
        r = r.whenComplete((status, t) -> this.shutdown());
        return r;
    }

    private void shutdown() {
        this.status = ComponentStatus.STOPPING;
        this.protocolServers.values().parallelStream().forEach(ps -> ps.stop());
        this.cacheManagers.values().forEach(cm -> cm.stop());
        this.status = ComponentStatus.TERMINATED;
    }

    public ConfigurationBuilderHolder getConfigurationBuilderHolder() {
        return this.configurationBuilderHolder;
    }

    public File getServerRoot() {
        return this.serverRoot;
    }

    public Map<String, DefaultCacheManager> getCacheManagers() {
        return this.cacheManagers;
    }

    public Map<String, ProtocolServer> getProtocolServers() {
        return this.protocolServers;
    }
}

