/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.server.configuration.hotrod;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.SslConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.server.configuration.ServerConfigurationParser;
import org.infinispan.server.server.configuration.hotrod.Attribute;
import org.infinispan.server.server.configuration.hotrod.Element;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="hotrod-connector"), @Namespace(uri="urn:infinispan:server:*", root="hotrod-connector")})
public class HotRodServerConfigurationParser
implements ConfigurationParser {
    private static Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope(ServerConfigurationParser.ENDPOINTS_SCOPE)) {
            throw coreLog.invalidScope(ServerConfigurationParser.ENDPOINTS_SCOPE, holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case HOTROD_CONNECTOR: {
                ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)builder.module(ServerConfigurationBuilder.class);
                if (serverBuilder == null) break;
                this.parseHotRodConnector(reader, holder, serverBuilder, serverBuilder.addEndpoint(HotRodServerConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseHotRodConnector(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ServerConfigurationBuilder serverBuilder, HotRodServerConfigurationBuilder builder) throws XMLStreamException {
        block20: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE_CONTAINER: {
                    continue block20;
                }
                case EXTERNAL_HOST: {
                    builder.proxyHost(value);
                    continue block20;
                }
                case EXTERNAL_PORT: {
                    builder.proxyPort(Integer.parseInt(value));
                    continue block20;
                }
                case IDLE_TIMEOUT: {
                    builder.idleTimeout(Integer.parseInt(value));
                    continue block20;
                }
                case IO_THREADS: {
                    builder.ioThreads(Integer.parseInt(value));
                    continue block20;
                }
                case NAME: {
                    builder.name(value);
                    continue block20;
                }
                case RECEIVE_BUFFER_SIZE: {
                    builder.recvBufSize(Integer.parseInt(value));
                    continue block20;
                }
                case SECURITY_REALM: {
                    continue block20;
                }
                case SEND_BUFFER_SIZE: {
                    builder.sendBufSize(Integer.parseInt(value));
                    continue block20;
                }
                case SOCKET_BINDING: {
                    serverBuilder.applySocketBinding(value, (ProtocolServerConfigurationBuilder)builder);
                    continue block20;
                }
                case TCP_KEEPALIVE: {
                    builder.tcpKeepAlive(Boolean.parseBoolean(value));
                    continue block20;
                }
                case TCP_NODELAY: {
                    builder.tcpNoDelay(Boolean.parseBoolean(value));
                    continue block20;
                }
                case WORKER_THREADS: {
                    builder.workerThreads(Integer.parseInt(value));
                    continue block20;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block21: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TOPOLOGY_STATE_TRANSFER: {
                    this.parseTopologyStateTransfer(reader, builder);
                    continue block21;
                }
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, builder.authentication().enable());
                    continue block21;
                }
                case ENCRYPTION: {
                    this.parseEncryption(reader, builder.ssl().enable());
                    continue block21;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseEncryption(XMLExtendedStreamReader reader, SslConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REQUIRE_SSL_CLIENT_AUTH: {
                    builder.requireClientAuth(Boolean.parseBoolean(value));
                    continue block7;
                }
                case SECURITY_REALM: {
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SNI: {
                    this.parseSni(reader, builder);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSni(XMLExtendedStreamReader reader, SslConfigurationBuilder builder) {
    }

    private void parseAuthentication(XMLExtendedStreamReader reader, AuthenticationConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SASL: {
                    this.parseSasl(reader, builder);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseSasl(XMLExtendedStreamReader reader, AuthenticationConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SERVER_CONTEXT_NAME: {
                    continue block7;
                }
                case SERVER_NAME: {
                    builder.serverName(value);
                    continue block7;
                }
                case MECHANISMS: {
                    for (String mech : reader.getListAttributeValue(i)) {
                        builder.addAllowedMech(mech);
                    }
                    continue block7;
                }
                case QOP: {
                    builder.addMechProperty("javax.security.sasl.qop", value);
                    continue block7;
                }
                case STRENGTH: {
                    builder.addMechProperty("javax.security.sasl.strength", value);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseTopologyStateTransfer(XMLExtendedStreamReader reader, HotRodServerConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LOCK_TIMEOUT: {
                    builder.topologyLockTimeout(Long.parseLong(value));
                    continue block6;
                }
                case AWAIT_INITIAL_RETRIEVAL: {
                    builder.topologyAwaitInitialTransfer(Boolean.parseBoolean(value));
                    continue block6;
                }
                case REPLICATION_TIMEOUT: {
                    builder.topologyReplTimeout(Long.parseLong(value));
                    continue block6;
                }
                case LAZY_RETRIEVAL: {
                    builder.topologyStateTransfer(Boolean.parseBoolean(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }
}

