/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.server.configuration.rest;

import java.util.HashSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.server.Server;
import org.infinispan.server.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.server.configuration.ServerConfigurationParser;
import org.infinispan.server.server.configuration.rest.Attribute;
import org.infinispan.server.server.configuration.rest.Element;
import org.infinispan.server.server.network.SocketBinding;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="rest-connector"), @Namespace(uri="urn:infinispan:server:*", root="rest-connector")})
public class RestServerConfigurationParser
implements ConfigurationParser {
    private static Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope(ServerConfigurationParser.ENDPOINTS_SCOPE)) {
            throw coreLog.invalidScope(ServerConfigurationParser.ENDPOINTS_SCOPE, holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case REST_CONNECTOR: {
                ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)builder.module(ServerConfigurationBuilder.class);
                if (serverBuilder != null) {
                    this.parseRest(reader, serverBuilder);
                    break;
                }
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseRest(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder) throws XMLStreamException {
        RestServerConfigurationBuilder builder = serverBuilder.addEndpoint(RestServerConfigurationBuilder.class);
        block17: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SOCKET_BINDING: {
                    SocketBinding socketBinding = serverBuilder.getSocketBinding(value);
                    if (socketBinding != null) {
                        ((RestServerConfigurationBuilder)builder.host(socketBinding.getAddress().getAddress().getHostAddress())).port(socketBinding.getPort());
                        continue block17;
                    }
                    throw Server.log.unknownSocketBinding(value);
                }
                case CACHE_CONTAINER: {
                    continue block17;
                }
                case CONTEXT_PATH: {
                    builder.contextPath(value);
                    continue block17;
                }
                case EXTENDED_HEADERS: {
                    builder.extendedHeaders(ExtendedHeaders.valueOf((String)value));
                    continue block17;
                }
                case IDLE_TIMEOUT: {
                    builder.idleTimeout(Integer.parseInt(value));
                    continue block17;
                }
                case IO_THREADS: {
                    builder.ioThreads(Integer.parseInt(value));
                    continue block17;
                }
                case NAME: {
                    builder.name(value);
                    continue block17;
                }
                case MAX_CONTENT_LENGTH: {
                    builder.maxContentLength(Integer.parseInt(value));
                    continue block17;
                }
                case COMPRESSION_LEVEL: {
                    builder.compressionLevel(Integer.parseInt(value));
                    continue block17;
                }
                case IGNORED_CACHES: {
                    String[] values;
                    HashSet<String> ignoredCaches = new HashSet<String>();
                    for (String v : values = reader.getListAttributeValue(i)) {
                        ignoredCaches.add(v);
                    }
                    builder.ignoredCaches(ignoredCaches);
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, builder);
                    continue block19;
                }
                case ENCRYPTION: {
                    this.parseEncryption(reader, builder);
                    continue block19;
                }
                case CORS_RULES: {
                    this.parseCorsRules(reader, builder);
                    continue block19;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private void parseCorsRules(XMLExtendedStreamReader reader, RestServerConfigurationBuilder builder) {
    }

    private void parseAuthentication(XMLExtendedStreamReader reader, RestServerConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    continue block4;
                }
                case AUTH_METHOD: {
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseEncryption(XMLExtendedStreamReader reader, RestServerConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            switch (attribute) {
                case REQUIRE_SSL_CLIENT_AUTH: {
                    builder.ssl().requireClientAuth(Boolean.parseBoolean(value));
                    continue block7;
                }
                case SECURITY_REALM: {
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        boolean skipTagCheckAtTheEnd = reader.hasNext();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SNI: {
                    this.parseSni(reader, builder);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
        }
        if (!skipTagCheckAtTheEnd) {
            ParseUtils.requireNoContent((XMLStreamReader)reader);
        }
    }

    private void parseSni(XMLExtendedStreamReader reader, RestServerConfigurationBuilder builder) {
    }
}

