/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.server.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.server.server.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String serverStarting = "ISPN080000: %s Server starting";
    private static final String serverStarted = "ISPN080001: %s Server %s started in %dms";
    private static final String serverStopping = "ISPN080002: %s Server stopping";
    private static final String serverStopped = "ISPN080003: %s Server stopped";
    private static final String protocolStarted = "ISPN080004: Protocol %s listening on %s:%d";
    private static final String duplicatePath = "ISPN080005: Duplicate path '%s'";
    private static final String duplicateNetworkInterface = "ISPN080006: Duplicate network interface '%s'";
    private static final String duplicateSocketBinding = "ISPN080007: Duplicate socket binding '%s'";
    private static final String cannotInstantiateProtocolServerConfigurationBuilder = "ISPN080008: Cannot instantiate protocol server configuration '%s'";
    private static final String unknownInterface = "ISPN080009: Unknown interface '%s'";
    private static final String unknownSocketBinding = "ISPN080010: Unknown socket binding '%s'";
    private static final String nonAbsolutePath = "ISPN080011: The path '%s' is not absolute";
    private static final String duplicateSecurityRealm = "ISPN080012: Duplicate security realm '%s'";
    private static final String duplicateRealmType = "ISPN080013: Duplicate realm type '%s' in realm '%s'";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void serverStarting(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStarting$str(), (Object)name);
    }

    protected String serverStarting$str() {
        return serverStarting;
    }

    @Override
    public final void serverStarted(String name, String version, long ms) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStarted$str(), (Object)name, (Object)version, (Object)ms);
    }

    protected String serverStarted$str() {
        return serverStarted;
    }

    @Override
    public final void serverStopping(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStopping$str(), (Object)name);
    }

    protected String serverStopping$str() {
        return serverStopping;
    }

    @Override
    public final void serverStopped(String name) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverStopped$str(), (Object)name);
    }

    protected String serverStopped$str() {
        return serverStopped;
    }

    @Override
    public final void protocolStarted(String name, String host, int port) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.protocolStarted$str(), (Object)name, (Object)host, (Object)port);
    }

    protected String protocolStarted$str() {
        return protocolStarted;
    }

    protected String duplicatePath$str() {
        return duplicatePath;
    }

    @Override
    public final CacheConfigurationException duplicatePath(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicatePath$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateNetworkInterface$str() {
        return duplicateNetworkInterface;
    }

    @Override
    public final CacheConfigurationException duplicateNetworkInterface(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateNetworkInterface$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateSocketBinding$str() {
        return duplicateSocketBinding;
    }

    @Override
    public final CacheConfigurationException duplicateSocketBinding(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateSocketBinding$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateProtocolServerConfigurationBuilder$str() {
        return cannotInstantiateProtocolServerConfigurationBuilder;
    }

    @Override
    public final CacheConfigurationException cannotInstantiateProtocolServerConfigurationBuilder(Class<?> klass, Exception e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotInstantiateProtocolServerConfigurationBuilder$str(), klass), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownInterface$str() {
        return unknownInterface;
    }

    @Override
    public final CacheConfigurationException unknownInterface(String interfaceName) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownInterface$str(), interfaceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownSocketBinding$str() {
        return unknownSocketBinding;
    }

    @Override
    public final CacheConfigurationException unknownSocketBinding(String value) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.unknownSocketBinding$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nonAbsolutePath$str() {
        return nonAbsolutePath;
    }

    @Override
    public final CacheConfigurationException nonAbsolutePath(String path) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.nonAbsolutePath$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateSecurityRealm$str() {
        return duplicateSecurityRealm;
    }

    @Override
    public final CacheConfigurationException duplicateSecurityRealm(String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateSecurityRealm$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateRealmType$str() {
        return duplicateRealmType;
    }

    @Override
    public final CacheConfigurationException duplicateRealmType(String type, String name) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.duplicateRealmType$str(), type, name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

