/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.core.LdapServerRule;
import org.infinispan.server.test.core.category.Security;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Security.class})
public class AuthenticationKerberosSpnegoIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = InfinispanServerRuleBuilder.config((String)"configuration/AuthenticationKerberosTest.xml").numServers(1).property("java.security.krb5.conf", "${infinispan.server.config.path}/krb5.conf").build();
    @ClassRule
    public static LdapServerRule LDAP = new LdapServerRule(SERVERS, "ldif/infinispan-kerberos.ldif", true);
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final Protocol protocol;
    private final String mechanism;
    private static String oldKrb5Conf;

    @Parameterized.Parameters(name="{1}({0})")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(Common.HTTP_KERBEROS_MECHS.size() * Common.HTTP_PROTOCOLS.size());
        for (Protocol protocol : Common.HTTP_PROTOCOLS) {
            for (Object[] mech : Common.HTTP_KERBEROS_MECHS) {
                params.add(new Object[]{protocol, mech[0]});
            }
        }
        return params;
    }

    public AuthenticationKerberosSpnegoIT(Protocol protocol, String mechanism) {
        this.protocol = protocol;
        this.mechanism = mechanism;
    }

    @BeforeClass
    public static void setKrb5Conf() {
        oldKrb5Conf = System.setProperty("java.security.krb5.conf", AuthenticationKerberosSpnegoIT.class.getClassLoader().getResource("configuration/krb5.conf").getPath());
    }

    @AfterClass
    public static void restoreKrb5Conf() {
        if (oldKrb5Conf != null) {
            System.setProperty("java.security.krb5.conf", oldKrb5Conf);
        }
    }

    @Test
    public void testReadWrite() {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        if (!this.mechanism.isEmpty()) {
            builder.protocol(this.protocol).security().authentication().mechanism(this.mechanism).clientSubject(Common.createSubject("admin", "INFINISPAN.ORG", "strongPassword".toCharArray()));
        }
        if (this.mechanism.isEmpty()) {
            Exceptions.expectException(RuntimeException.class, () -> this.SERVER_TEST.rest().withClientConfiguration(builder).create());
        } else {
            RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
            RestResponse response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).post("k1", "v1"));
            Assert.assertEquals((long)204L, (long)response.getStatus());
            Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
            response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).get("k1"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
            Assert.assertEquals((Object)"v1", (Object)response.getBody());
        }
    }
}

