/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.core.LdapServerRule;
import org.infinispan.server.test.core.category.Security;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Security.class})
public class AuthenticationLDAPIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = InfinispanServerRuleBuilder.config((String)"configuration/AuthenticationLDAPTest.xml").build();
    @ClassRule
    public static LdapServerRule LDAP = new LdapServerRule(SERVERS);
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final String mechanism;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Common.SASL_MECHS;
    }

    public AuthenticationLDAPIT(String mechanism) {
        this.mechanism = mechanism;
    }

    @Test
    public void testReadWrite() {
        block3: {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (!this.mechanism.isEmpty()) {
                builder.security().authentication().saslMechanism(this.mechanism).serverName("infinispan").realm("default").username("admin").password("strongPassword");
            }
            try {
                RemoteCache cache = ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withClientConfiguration(builder).withCacheMode(CacheMode.DIST_SYNC)).create();
                cache.put((Object)"k1", (Object)"v1");
                Assert.assertEquals((long)1L, (long)cache.size());
                Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
            }
            catch (HotRodClientException e) {
                if (this.mechanism.isEmpty()) break block3;
                throw e;
            }
        }
    }
}

