/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.extensions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.extensions.ExtensionsIT;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ScriptingTasks {
    @ClassRule
    public static final InfinispanServerRule SERVERS = ExtensionsIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testSimpleScript() {
        RemoteCache cache = this.SERVER_TEST.hotrod().create();
        String scriptName = this.SERVER_TEST.addScript(cache.getRemoteCacheManager(), "scripts/test.js");
        cache.put((Object)"keyA", (Object)"A");
        cache.put((Object)"keyB", (Object)"B");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key", "keyC");
        parameters.put("value", "C");
        int result = (Integer)cache.execute(scriptName, parameters);
        Assert.assertEquals((long)3L, (long)result);
    }

    @Test
    public void testStreamingScript() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.marshaller((Marshaller)new JavaSerializationMarshaller()).addJavaSerialWhiteList(new String[]{HashMap.class.getName()});
        org.infinispan.configuration.cache.ConfigurationBuilder cacheBuilder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        cacheBuilder.clustering().cacheMode(CacheMode.DIST_SYNC).encoding().key().mediaType("application/x-java-serialized-object").encoding().value().mediaType("application/x-java-serialized-object");
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withClientConfiguration(builder).withServerConfiguration(cacheBuilder)).create();
        String scriptName = this.SERVER_TEST.addScript(cache.getRemoteCacheManager(), "scripts/stream.js");
        cache.put((Object)"key1", (Object)"Lorem ipsum dolor sit amet");
        cache.put((Object)"key2", (Object)"consectetur adipiscing elit");
        cache.put((Object)"key3", (Object)"sed do eiusmod tempor incididunt ut labore et dolore magna aliqua");
        Map result = (Map)cache.execute(scriptName, Collections.emptyMap());
        Assert.assertEquals((long)19L, (long)result.size());
    }
}

