/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvents;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.remote.client.FilterResult;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HotRodListenerWithDslFilter {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testEventFilter() {
        RemoteCache remoteCache = ClusteredIT.createQueryableCache(this.SERVER_TEST, true);
        User user1 = new User();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(Integer.valueOf(22));
        user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
        user1.setNotes("Lorem ipsum dolor sit amet");
        Address address1 = new Address();
        address1.setStreet("Main Street");
        address1.setPostCode("X1234");
        user1.setAddresses(Collections.singletonList(address1));
        User user2 = new User();
        user2.setId(2);
        user2.setName("Spider");
        user2.setSurname("Man");
        user2.setGender(User.Gender.MALE);
        user2.setAge(Integer.valueOf(32));
        user2.setAccountIds(Collections.singleton(3));
        Address address2 = new Address();
        address2.setStreet("Old Street");
        address2.setPostCode("Y12");
        Address address3 = new Address();
        address3.setStreet("Bond Street");
        address3.setPostCode("ZZ");
        user2.setAddresses(Arrays.asList(address2, address3));
        User user3 = new User();
        user3.setId(3);
        user3.setName("Spider");
        user3.setSurname("Woman");
        user3.setGender(User.Gender.FEMALE);
        user3.setAge(Integer.valueOf(31));
        user3.setAccountIds(Collections.emptySet());
        remoteCache.put((Object)user1.getId(), (Object)user1);
        remoteCache.put((Object)user2.getId(), (Object)user2);
        remoteCache.put((Object)user3.getId(), (Object)user3);
        Assert.assertEquals((long)3L, (long)remoteCache.size());
        SerializationContext serCtx = MarshallerUtil.getSerializationContext((RemoteCacheManager)remoteCache.getRemoteCacheManager());
        QueryFactory qf = Search.getQueryFactory(remoteCache);
        Query query = qf.from(User.class).having("age").lte((Object)Expression.param((String)"ageParam")).select(new String[]{"age"}).build().setParameter("ageParam", (Object)32);
        ClientEntryListener listener = new ClientEntryListener(serCtx);
        ClientEvents.addClientQueryListener(remoteCache, (Object)listener, (Query)query);
        this.expectElementsInQueue(listener.createEvents, 3);
        user3.setAge(Integer.valueOf(40));
        remoteCache.put((Object)user1.getId(), (Object)user1);
        remoteCache.put((Object)user2.getId(), (Object)user2);
        remoteCache.put((Object)user3.getId(), (Object)user3);
        Assert.assertEquals((long)3L, (long)remoteCache.size());
        this.expectElementsInQueue(listener.modifyEvents, 2);
        remoteCache.removeClientListener((Object)listener);
    }

    private void expectElementsInQueue(BlockingQueue<?> queue, int numElements) {
        for (int i = 0; i < numElements; ++i) {
            try {
                Object e = queue.poll(5L, TimeUnit.SECONDS);
                Assert.assertNotNull((String)"Queue was empty!", e);
                continue;
            }
            catch (InterruptedException e) {
                throw new AssertionError("Interrupted while waiting for condition", e);
            }
        }
        try {
            Object e = queue.poll(5L, TimeUnit.SECONDS);
            Assert.assertNull((String)"No more elements expected in queue!", e);
        }
        catch (InterruptedException e) {
            throw new AssertionError("Interrupted while waiting for condition", e);
        }
    }

    @ClientListener(filterFactoryName="query-dsl-filter-converter-factory", converterFactoryName="query-dsl-filter-converter-factory", useRawData=true, includeCurrentState=true)
    public static class ClientEntryListener {
        private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
        public final BlockingQueue<FilterResult> createEvents = new LinkedBlockingQueue<FilterResult>();
        public final BlockingQueue<FilterResult> modifyEvents = new LinkedBlockingQueue<FilterResult>();
        private final SerializationContext serializationContext;

        public ClientEntryListener(SerializationContext serializationContext) {
            this.serializationContext = serializationContext;
        }

        @ClientCacheEntryCreated
        public void handleClientCacheEntryCreatedEvent(ClientCacheEntryCustomEvent event) throws IOException {
            FilterResult r = (FilterResult)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.serializationContext, (byte[])((byte[])event.getEventData()));
            this.createEvents.add(r);
            log.debugf("handleClientCacheEntryCreatedEvent instance=%s projection=%s sortProjection=%s\n", r.getInstance(), r.getProjection() == null ? null : Arrays.asList(r.getProjection()), r.getSortProjection() == null ? null : Arrays.asList(r.getSortProjection()));
        }

        @ClientCacheEntryModified
        public void handleClientCacheEntryModifiedEvent(ClientCacheEntryCustomEvent event) throws IOException {
            FilterResult r = (FilterResult)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.serializationContext, (byte[])((byte[])event.getEventData()));
            this.modifyEvents.add(r);
            log.debugf("handleClientCacheEntryModifiedEvent instance=%s projection=%s sortProjection=%s\n", r.getInstance(), r.getProjection() == null ? null : Arrays.asList(r.getProjection()), r.getSortProjection() == null ? null : Arrays.asList(r.getSortProjection()));
        }

        @ClientCacheEntryRemoved
        public void handleClientCacheEntryRemovedEvent(ClientCacheEntryRemovedEvent event) {
            log.debugf("handleClientCacheEntryRemovedEvent %s\n", event.getKey());
        }
    }
}

