/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RestLoggingResource {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testListLoggers() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse response = (RestResponse)Common.sync(client.server().logging().listLoggers());
        JsonNode loggers = this.mapper.readTree(response.getBody());
        Assert.assertTrue((loggers.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testListAppenders() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse response = (RestResponse)Common.sync(client.server().logging().listAppenders());
        JsonNode appenders = this.mapper.readTree(response.getBody());
        Assert.assertEquals((long)2L, (long)appenders.size());
    }

    @Test
    public void testManipulateLogger() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse response = (RestResponse)Common.sync(client.server().logging().setLogger("org.infinispan.TESTLOGGER", "WARN", new String[]{"STDOUT"}));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = (RestResponse)Common.sync(client.server().logging().listLoggers());
        Assert.assertTrue((String)"Logger not found", (boolean)this.findLogger(response, "org.infinispan.TESTLOGGER", "WARN", "STDOUT"));
        response = (RestResponse)Common.sync(client.server().logging().setLogger("org.infinispan.TESTLOGGER", "ERROR", new String[]{"File"}));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = (RestResponse)Common.sync(client.server().logging().listLoggers());
        Assert.assertTrue((String)"Logger not found", (boolean)this.findLogger(response, "org.infinispan.TESTLOGGER", "ERROR", "File"));
        response = (RestResponse)Common.sync(client.server().logging().removeLogger("org.infinispan.TESTLOGGER"));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = (RestResponse)Common.sync(client.server().logging().listLoggers());
        Assert.assertFalse((String)"Logger should not be found", (boolean)this.findLogger(response, "org.infinispan.TESTLOGGER", "ERROR", new String[0]));
    }

    private boolean findLogger(RestResponse response, String name, String level, String ... appenders) throws JsonProcessingException {
        JsonNode loggers = this.mapper.readTree(response.getBody());
        for (int i = 0; i < loggers.size(); ++i) {
            JsonNode logger = loggers.get(i);
            if (!name.equals(logger.get("name").asText())) continue;
            Assert.assertEquals((Object)level, (Object)logger.get("level").asText());
            JsonNode loggerAppenders = logger.get("appenders");
            Assert.assertEquals((long)appenders.length, (long)loggerAppenders.size());
            for (int j = 0; j < appenders.length; ++j) {
                Assert.assertEquals((Object)appenders[j], (Object)loggerAppenders.get(j).asText());
            }
            return true;
        }
        return false;
    }
}

