/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.KeyCloakServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class AuthenticationKeyCloakIT {
    @ClassRule
    public static final InfinispanServerRule SERVERS = InfinispanServerRuleBuilder.config((String)"configuration/AuthenticationKeyCloakTest.xml").build();
    @ClassRule
    public static KeyCloakServerRule KEYCLOAK = new KeyCloakServerRule("keycloak/infinispan-keycloak-realm.json");
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testHotRodReadWrite() {
        String token = KEYCLOAK.getAccessTokenForCredentials("infinispan", "infinispan-client", "8a43581d-62d7-47dc-9aa4-cd3af24b6083", "admin", "adminPassword");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().authentication().saslMechanism("OAUTHBEARER").serverName("infinispan").realm("default").token(token);
        RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withClientConfiguration(builder).withCacheMode(CacheMode.DIST_SYNC)).create();
        cache.put((Object)"k1", (Object)"v1");
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
    }

    @Test
    public void testRestReadWrite() {
        String token = KEYCLOAK.getAccessTokenForCredentials("infinispan", "infinispan-client", "8a43581d-62d7-47dc-9aa4-cd3af24b6083", "admin", "adminPassword");
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.security().authentication().mechanism("BEARER_TOKEN").username(token);
        RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
        RestResponse response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).post("k1", "v1"));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).get("k1"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"v1", (Object)response.getBody());
    }
}

