/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.server.test.core.JBossLoggingConsumer;
import org.infinispan.test.TestingUtil;
import org.jboss.logging.BasicLogger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

public class KeyCloakServerRule
implements TestRule {
    public static final String KEYCLOAK_IMAGE = "jboss/keycloak:8.0.1";
    private final String realmJsonFile;
    private FixedHostPortGenericContainer container;

    public KeyCloakServerRule(String realmJsonFile) {
        this.realmJsonFile = realmJsonFile;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                KeyCloakServerRule.this.before(description.getTestClass());
                try {
                    base.evaluate();
                }
                finally {
                    KeyCloakServerRule.this.after();
                }
            }
        };
    }

    private void before(Class<?> testClass) {
        File keycloakDirectory = new File(CommonsTestingUtil.tmpDirectory((String[])new String[]{"keycloak"}));
        keycloakDirectory.mkdirs();
        File keycloakImport = new File(keycloakDirectory, "keycloak.json");
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.realmJsonFile);
             FileOutputStream os = new FileOutputStream(keycloakImport);){
            TestingUtil.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("DB_VENDOR", "h2");
        environment.put("KEYCLOAK_USER", "keycloak");
        environment.put("KEYCLOAK_PASSWORD", "keycloak");
        environment.put("KEYCLOAK_IMPORT", keycloakImport.getAbsolutePath());
        this.container = new FixedHostPortGenericContainer(KEYCLOAK_IMAGE);
        this.container.withFixedExposedPort(14567, 8080).withEnv(environment).withCopyFileToContainer(MountableFile.forHostPath((String)keycloakImport.getAbsolutePath()), keycloakImport.getPath()).withLogConsumer((Consumer)new JBossLoggingConsumer((BasicLogger)LogFactory.getLog(testClass))).waitingFor((WaitStrategy)Wait.forHttp((String)"/"));
        this.container.start();
    }

    public String getAccessTokenForCredentials(String realm, String client, String secret, String username, String password) {
        String string;
        block8: {
            RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
            builder.addServer().host(this.container.getContainerIpAddress()).port(this.container.getMappedPort(8080).intValue()).connectionTimeout(5000L).socketTimeout(5000L);
            RestClient c = RestClient.forConfiguration((RestClientConfiguration)builder.build());
            try {
                String url = String.format("/auth/realms/%s/protocol/openid-connect/token", realm);
                HashMap<String, List<String>> form = new HashMap<String, List<String>>();
                form.put("client_id", Collections.singletonList(client));
                form.put("client_secret", Collections.singletonList(secret));
                form.put("username", Collections.singletonList(username));
                form.put("password", Collections.singletonList(password));
                form.put("grant_type", Collections.singletonList("password"));
                RestResponse response = (RestResponse)c.raw().postForm(url, Collections.singletonMap("Content-Type", "application/x-www-form-urlencoded"), form).toCompletableFuture().get(5L, TimeUnit.SECONDS);
                ObjectMapper mapper = new ObjectMapper();
                Map map = (Map)mapper.readValue(response.getBody(), Map.class);
                string = (String)map.get("access_token");
                if (c == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            c.close();
        }
        return string;
    }

    private void after() {
        this.container.close();
    }
}

