/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.core.LdapServerRule;
import org.infinispan.server.test.core.category.Security;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Security.class})
public class AuthorizationLDAPIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = InfinispanServerRuleBuilder.config((String)"configuration/AuthorizationLDAPTest.xml").build();
    @ClassRule
    public static LdapServerRule LDAP = new LdapServerRule(SERVERS);
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    final Map<String, ConfigurationBuilder> hotRodBuilders = new HashMap<String, ConfigurationBuilder>();
    final Map<String, RestClientConfigurationBuilder> restBuilders = new HashMap<String, RestClientConfigurationBuilder>();
    final Map<String, String> bulkData;

    public AuthorizationLDAPIT() {
        this.addClientBuilders("admin", "strongPassword");
        this.addClientBuilders("writer", "somePassword");
        this.addClientBuilders("reader", "password");
        this.addClientBuilders("supervisor", "lessStrongPassword");
        this.bulkData = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            this.bulkData.put("k" + i, "v" + i);
        }
    }

    private void addClientBuilders(String username, String password) {
        ConfigurationBuilder hotRodBuilder = new ConfigurationBuilder();
        hotRodBuilder.security().authentication().saslMechanism("SCRAM-SHA-1").serverName("infinispan").realm("default").username(username).password(password);
        this.hotRodBuilders.put(username, hotRodBuilder);
        RestClientConfigurationBuilder restBuilder = new RestClientConfigurationBuilder();
        restBuilder.security().authentication().mechanism("AUTO").username(username).password(password);
        this.restBuilders.put(username, restBuilder);
    }

    @Test
    public void testHotRodAdminCanDoEverything() {
        RemoteCache adminCache = ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withClientConfiguration(this.hotRodBuilders.get("admin")).withCacheMode(CacheMode.DIST_SYNC)).create();
        adminCache.put((Object)"k", (Object)"v");
        Assert.assertEquals((Object)"v", (Object)adminCache.get((Object)"k"));
        adminCache.putAll(this.bulkData);
        Assert.assertEquals((long)11L, (long)adminCache.size());
    }

    @Test
    public void testRestAdminCanDoEverything() {
        RestCacheClient adminCache = ((InfinispanServerTestMethodRule.Rest)this.SERVER_TEST.rest().withClientConfiguration(this.restBuilders.get("admin")).withCacheMode(CacheMode.DIST_SYNC)).create().cache(this.SERVER_TEST.getMethodName());
        Common.sync(adminCache.put("k", "v"));
        Assert.assertEquals((Object)"v", (Object)((RestResponse)Common.sync(adminCache.get("k"))).getBody());
    }

    @Test
    public void testHotRodNonAdminsMustNotCreateCache() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).withCacheMode(CacheMode.DIST_SYNC)).create());
        }
    }

    @Test
    public void testRestNonAdminsMustNotCreateCache() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Exceptions.expectException(RuntimeException.class, (String)"(?s).*403.*", () -> ((InfinispanServerTestMethodRule.Rest)this.SERVER_TEST.rest().withClientConfiguration(this.restBuilders.get(user)).withCacheMode(CacheMode.DIST_SYNC)).create());
        }
    }

    @Test
    public void testHotRodWriterCannotRead() {
        this.hotRodCreateAuthzCache();
        RemoteCache writerCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.hotRodBuilders.get("writer")).get();
        writerCache.put((Object)"k1", (Object)"v1");
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> writerCache.get((Object)"k1"));
        for (String user : Arrays.asList("reader", "supervisor")) {
            RemoteCache userCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).get();
            Assert.assertEquals((Object)"v1", (Object)userCache.get((Object)"k1"));
        }
    }

    @Test
    public void testRestWriterCannotRead() {
        this.restCreateAuthzCache();
        RestCacheClient writerCache = this.SERVER_TEST.rest().withClientConfiguration(this.restBuilders.get("writer")).get().cache(this.SERVER_TEST.getMethodName());
        Common.sync(writerCache.put("k1", "v1"));
        Assert.assertEquals((long)403L, (long)((RestResponse)Common.sync(writerCache.get("k1"))).getStatus());
        for (String user : Arrays.asList("reader", "supervisor")) {
            RestCacheClient userCache = this.SERVER_TEST.rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(this.SERVER_TEST.getMethodName());
            Assert.assertEquals((Object)"v1", (Object)((RestResponse)Common.sync(userCache.get("k1"))).getBody());
        }
    }

    @Test
    public void testHotRodReaderCannotWrite() {
        this.hotRodCreateAuthzCache();
        RemoteCache readerCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.hotRodBuilders.get("reader")).get();
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.put((Object)"k1", (Object)"v1"));
        for (String user : Arrays.asList("writer", "supervisor")) {
            RemoteCache userCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).get();
            userCache.put((Object)user, (Object)user);
        }
    }

    @Test
    public void testRestReaderCannotWrite() {
        this.restCreateAuthzCache();
        RestCacheClient readerCache = this.SERVER_TEST.rest().withClientConfiguration(this.restBuilders.get("reader")).get().cache(this.SERVER_TEST.getMethodName());
        Assert.assertEquals((long)403L, (long)((RestResponse)Common.sync(readerCache.put("k1", "v1"))).getStatus());
        for (String user : Arrays.asList("writer", "supervisor")) {
            RestCacheClient userCache = this.SERVER_TEST.rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(this.SERVER_TEST.getMethodName());
            userCache.put(user, user);
        }
    }

    @Test
    public void testHotRodBulkOperations() {
        this.hotRodCreateAuthzCache().putAll(this.bulkData);
        RemoteCache readerCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.hotRodBuilders.get("reader")).get();
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.getAll(this.bulkData.keySet()));
        RemoteCache supervisorCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.hotRodBuilders.get("supervisor")).get();
        supervisorCache.getAll(this.bulkData.keySet());
    }

    @Test
    public void testAnonymousHealthPredefinedCache() {
        RestClient client = this.SERVER_TEST.rest().get();
        Assert.assertEquals((Object)"HEALTHY", (Object)((RestResponse)Common.sync(client.cacheManager("default").healthStatus())).getBody());
    }

    private RemoteCache<Object, Object> hotRodCreateAuthzCache() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).security().authorization().enable().role("AdminRole").role("ReaderRole").role("WriterRole").role("SupervisorRole");
        return ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withClientConfiguration(this.hotRodBuilders.get("admin")).withServerConfiguration(builder)).create();
    }

    private RestClient restCreateAuthzCache() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).security().authorization().enable().role("AdminRole").role("ReaderRole").role("WriterRole").role("SupervisorRole");
        return ((InfinispanServerTestMethodRule.Rest)this.SERVER_TEST.rest().withClientConfiguration(this.restBuilders.get("admin")).withServerConfiguration(builder)).create();
    }
}

