/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.Iterator;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class JCacheOperations {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testJCacheOperations() throws IOException {
        Properties properties = new Properties();
        InetAddress serverAddress = SERVERS.getServerDriver().getServerAddress(0);
        properties.put("infinispan.client.hotrod.server_list", serverAddress.getHostAddress() + ":11222");
        properties.put("infinispan.client.hotrod.cache." + this.SERVER_TEST.getMethodName() + ".template_name", "org.infinispan.DIST_SYNC");
        File file = new File("target/test-classes/jcache-hotrod-client.properties");
        try (FileOutputStream fos = new FileOutputStream(file);){
            properties.store(fos, null);
        }
        URI uri = file.toURI();
        CachingProvider provider = Caching.getCachingProvider();
        try (CacheManager cacheManager = provider.getCacheManager(uri, this.getClass().getClassLoader());){
            Cache cache = cacheManager.getCache(this.SERVER_TEST.getMethodName());
            cache.put((Object)"k1", (Object)"v1");
            int size = this.getCacheSize((Cache<String, String>)cache);
            Assert.assertEquals((long)1L, (long)size);
            Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
            cache.remove((Object)"k1");
            Assert.assertEquals((long)0L, (long)this.getCacheSize((Cache<String, String>)cache));
        }
    }

    private int getCacheSize(Cache<String, String> cache) {
        int size = 0;
        Iterator it = cache.iterator();
        while (it.hasNext()) {
            ++size;
            it.next();
        }
        return size;
    }
}

