/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resilience;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.core.ContainerInfinispanServerDriver;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StatefulSetRollingUpgradeIT {
    private static final int NUM_ROLLING_UPGRADES = 4;
    private static final String CACHE_MANAGER = "default";
    private final int numServers;
    private InfinispanServerRule serverRule;
    private InfinispanServerTestMethodRule methodRule;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({2}, {3}, {4}, {5});
    }

    public StatefulSetRollingUpgradeIT(int numServers) {
        this.numServers = numServers;
    }

    @Rule
    public RuleChain getRuleChain() {
        this.serverRule = InfinispanServerRuleBuilder.config((String)"configuration/ClusteredServerTest.xml").numServers(this.numServers).runMode(ServerRunMode.CONTAINER).parallelStartup(false).build();
        this.methodRule = new InfinispanServerTestMethodRule(this.serverRule);
        return RuleChain.outerRule((TestRule)this.serverRule).around((TestRule)this.methodRule);
    }

    @Test
    public void testStatefulSetRollingUpgrade() {
        IntStream.range(0, this.numServers).forEach(this::assertLiveness);
        ContainerInfinispanServerDriver serverDriver = (ContainerInfinispanServerDriver)this.serverRule.getServerDriver();
        for (int i = 0; i < 4; ++i) {
            for (int j = this.numServers - 1; j > -1; --j) {
                serverDriver.stop(j);
                serverDriver.restart(j);
                this.assertLiveness(j);
            }
        }
    }

    private void assertLiveness(int server) {
        RestClient rest = this.methodRule.rest().get(server);
        RestResponse rsp = (RestResponse)Common.sync(rest.cacheManager(CACHE_MANAGER).healthStatus(), 10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)HttpResponseStatus.OK.code(), (long)rsp.getStatus());
    }
}

