/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.authentication;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.server.security.Common;
import org.infinispan.server.security.authentication.AuthenticationIT;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.category.Security;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Security.class})
public class RestAuthentication {
    @ClassRule
    public static InfinispanServerRule SERVERS = AuthenticationIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final Protocol protocol;
    private final String mechanism;

    @Parameterized.Parameters(name="{1}({0})")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(Common.HTTP_MECHS.size() * Common.HTTP_PROTOCOLS.size());
        for (Protocol protocol : Common.HTTP_PROTOCOLS) {
            for (Object[] mech : Common.HTTP_MECHS) {
                params.add(new Object[]{protocol, mech[0]});
            }
        }
        return params;
    }

    public RestAuthentication(Protocol protocol, String mechanism) {
        this.protocol = protocol;
        this.mechanism = mechanism;
    }

    @Test
    public void testStaticResourcesAnonymously() {
        InfinispanServerDriver serverDriver = SERVERS.getServerDriver();
        InetSocketAddress serverAddress = serverDriver.getServerSocket(0, 11222);
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder().followRedirects(false);
        builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        RestClient restClient = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        RestResponse response = (RestResponse)Common.sync(restClient.raw().get("/"));
        Assert.assertEquals((long)307L, (long)response.getStatus());
    }

    @Test
    public void testRestReadWrite() {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        if (!this.mechanism.isEmpty()) {
            builder.protocol(this.protocol).security().authentication().mechanism(this.mechanism).realm("default").username("all_user").password("all");
        }
        if (this.mechanism.isEmpty()) {
            Exceptions.expectException(RuntimeException.class, () -> this.SERVER_TEST.rest().withClientConfiguration(builder).create());
        } else {
            RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
            RestResponse response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).post("k1", "v1"));
            Assert.assertEquals((long)204L, (long)response.getStatus());
            Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
            response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).get("k1"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
            Assert.assertEquals((Object)"v1", (Object)response.getBody());
        }
    }
}

