/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.impl.okhttp.StringRestEntityOkHttp;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.server.test.core.AbstractInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.util.concurrent.CompletionStages;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RollingUpgradeIT {
    protected static final String CACHE_NAME = "rolling";
    private static final int ENTRIES = 50;
    public static final JsonWriter JSON_WRITER = new JsonWriter();
    public static final ObjectMapper MAPPER = new ObjectMapper();
    private Cluster source;
    private Cluster target;

    @Before
    public void before() {
        String config = "configuration/ClusteredServerTest.xml";
        this.source = new Cluster(new ClusterConfiguration(config, 2, 0));
        this.target = new Cluster(new ClusterConfiguration(config, 2, 1000));
        this.source.start("source");
        this.target.start("target");
        Assert.assertEquals((long)2L, (long)this.source.getMembers().size());
        Assert.assertEquals((long)2L, (long)this.target.getMembers().size());
        Assert.assertNotSame(this.source.getMembers(), this.target.getMembers());
    }

    @After
    public void after() throws Exception {
        this.source.stop("source");
        this.target.stop("target");
    }

    @Test
    public void testRollingUpgrade() throws IOException {
        RestClient restClientSource = this.source.getClient();
        RestClient restClientTarget = this.target.getClient();
        this.createSourceClusterCache(restClientSource);
        this.createTargetClusterCache(restClientTarget);
        this.addSchema(restClientSource);
        this.addSchema(restClientTarget);
        this.populateCluster(restClientSource);
        Assert.assertEquals((Object)"name-20", (Object)this.getPersonName("20", restClientTarget));
        this.doRollingUpgrade(restClientTarget);
        this.disconnectSource(restClientTarget);
        Assert.assertEquals((long)50L, (long)this.getCacheSize(CACHE_NAME, restClientTarget));
        Assert.assertEquals((Object)"name-35", (Object)this.getPersonName("35", restClientTarget));
    }

    private int getCacheSize(String cacheName, RestClient restClient) {
        RestCacheClient cache = restClient.cache(cacheName);
        return Integer.parseInt(((RestResponse)CompletionStages.join((CompletionStage)cache.size())).getBody());
    }

    protected void disconnectSource(RestClient client) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)client.cache(CACHE_NAME).disconnectSource());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    protected void doRollingUpgrade(RestClient client) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)client.cache(CACHE_NAME).synchronizeData());
        Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatus());
    }

    private String getPersonName(String id, RestClient client) throws IOException {
        RestResponse resp = (RestResponse)CompletionStages.join((CompletionStage)client.cache(CACHE_NAME).get(id));
        String body = resp.getBody();
        Assert.assertEquals((String)body, (long)200L, (long)resp.getStatus());
        return MAPPER.readTree(body).get("name").asText();
    }

    public void populateCluster(RestClient client) {
        RestCacheClient cache = client.cache(CACHE_NAME);
        for (int i = 0; i < 50; ++i) {
            String person = this.createPerson("name-" + i);
            CompletionStages.join((CompletionStage)cache.put(String.valueOf(i), person));
        }
        Assert.assertEquals((long)50L, (long)this.getCacheSize(CACHE_NAME, client));
    }

    private String createPerson(String name) {
        return String.format("{\"_type\":\"Person\",\"name\":\"%s\"}", name);
    }

    private void addSchema(RestClient client) {
        RestCacheClient cache = client.cache("___protobuf_metadata");
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)cache.put("schema.proto", "message Person {required string name = 1;}"));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        RestResponse errorResponse = (RestResponse)CompletionStages.join((CompletionStage)client.cache("___protobuf_metadata").get("schema.proto.errors"));
        Assert.assertEquals((long)404L, (long)errorResponse.getStatus());
    }

    private void createTargetClusterCache(RestClient client) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((RemoteStoreConfigurationBuilder)builder.clustering().cacheMode(CacheMode.DIST_SYNC).persistence().addStore(RemoteStoreConfigurationBuilder.class)).remoteCacheName(CACHE_NAME).hotRodWrapping(true).protocolVersion(ProtocolVersion.PROTOCOL_VERSION_25).addServer().host(this.source.driver.getServerAddress(0).getHostAddress()).port(11222);
        String cacheConfig = JSON_WRITER.toJSON((ConfigurationInfo)builder.build());
        StringRestEntityOkHttp body = new StringRestEntityOkHttp(MediaType.APPLICATION_JSON, cacheConfig);
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)client.cache(CACHE_NAME).createWithConfiguration((RestEntity)body, new CacheContainerAdmin.AdminFlag[0]));
        Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatus());
    }

    private void createSourceClusterCache(RestClient client) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        String cacheConfig = JSON_WRITER.toJSON((ConfigurationInfo)builder.build());
        StringRestEntityOkHttp body = new StringRestEntityOkHttp(MediaType.APPLICATION_JSON, cacheConfig);
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)client.cache(CACHE_NAME).createWithConfiguration((RestEntity)body, new CacheContainerAdmin.AdminFlag[0]));
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    static class Cluster {
        final AbstractInfinispanServerDriver driver;
        RestClient client;

        Cluster(ClusterConfiguration simpleConfiguration) {
            String driverProperty = System.getProperties().getProperty("org.infinispan.test.server.driver");
            if (driverProperty != null) {
                simpleConfiguration.properties().setProperty("org.infinispan.test.server.driver", driverProperty);
            }
            this.driver = ServerRunMode.DEFAULT.newDriver((InfinispanServerTestConfiguration)simpleConfiguration);
        }

        void start(String name) {
            this.driver.prepare(name);
            this.driver.start(name);
        }

        void stop(String name) throws Exception {
            this.driver.stop(name);
            if (this.client != null) {
                this.client.close();
            }
        }

        Set<String> getMembers() {
            String response = ((RestResponse)CompletionStages.join((CompletionStage)this.getClient().cacheManager("default").info())).getBody();
            try {
                JsonNode jsonNode = MAPPER.readTree(response);
                HashSet<String> names = new HashSet<String>();
                jsonNode.get("cluster_members").elements().forEachRemaining(n -> names.add(n.asText()));
                return names;
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
                return null;
            }
        }

        RestClient getClient() {
            if (this.client == null) {
                InetSocketAddress serverSocket = this.driver.getServerSocket(0, 11222);
                this.client = RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(serverSocket.getHostName()).port(serverSocket.getPort()).build());
            }
            return this.client;
        }
    }

    private static class ClusterConfiguration
    extends InfinispanServerTestConfiguration {
        public ClusterConfiguration(String configurationFile, int numServers, int portOffset) {
            super(configurationFile, numServers, ServerRunMode.EMBEDDED, new Properties(), null, null, false, false, false, Collections.emptyList(), null, portOffset);
        }
    }
}

