/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.Collections;
import org.infinispan.cli.user.UserTool;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerListener;

public class SecurityRealmServerListener
implements InfinispanServerListener {
    final String realm;

    public SecurityRealmServerListener(String realmName) {
        this.realm = realmName;
    }

    public void before(InfinispanServerDriver driver) {
        UserTool userTool = new UserTool(driver.getRootDir().getAbsolutePath(), this.realm + "-users.properties", this.realm + "-groups.properties");
        for (AuthorizationPermission authorizationPermission : AuthorizationPermission.values()) {
            String name = authorizationPermission.name().toLowerCase();
            userTool.createUser(name + "_user", name, this.realm, UserTool.Encryption.DEFAULT, Collections.singletonList(name), null);
        }
        for (AuthorizationPermission authorizationPermission : TestUser.values()) {
            userTool.createUser(authorizationPermission.getUser(), authorizationPermission.getPassword(), this.realm, UserTool.Encryption.DEFAULT, authorizationPermission.getRoles(), null);
        }
    }
}

