/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HotRodCacheQueries {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final boolean indexed;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{true});
        data.add(new Object[]{false});
        return data;
    }

    public HotRodCacheQueries(boolean indexed) {
        this.indexed = indexed;
    }

    @Test
    public void testAttributeQuery() {
        RemoteCache remoteCache = ClusteredIT.createQueryableCache(this.SERVER_TEST, this.indexed);
        remoteCache.put((Object)1, (Object)this.createUser1());
        remoteCache.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)remoteCache.get((Object)1);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(remoteCache);
        Query query = qf.create("FROM sample_bank_account.User WHERE name = 'Tom'");
        List list = query.execute().list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    @Test
    public void testEmbeddedAttributeQuery() {
        RemoteCache remoteCache = ClusteredIT.createQueryableCache(this.SERVER_TEST, this.indexed);
        remoteCache.put((Object)1, (Object)this.createUser1());
        remoteCache.put((Object)2, (Object)this.createUser2());
        QueryFactory qf = Search.getQueryFactory(remoteCache);
        Query query = qf.create("FROM sample_bank_account.User u WHERE u.addresses.postCode = '1234'");
        List list = query.execute().list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    @Test
    public void testProjections() {
        RemoteCache remoteCache = ClusteredIT.createQueryableCache(this.SERVER_TEST, this.indexed);
        remoteCache.put((Object)1, (Object)this.createUser1());
        remoteCache.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)remoteCache.get((Object)1);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(remoteCache);
        Query query = qf.create("SELECT name, surname FROM sample_bank_account.User WHERE name = 'Tom'");
        List list = query.execute().list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Object[].class, ((Object[])list.get(0)).getClass());
        Assert.assertEquals((Object)"Tom", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Cat", (Object)((Object[])list.get(0))[1]);
    }

    @Test
    public void testUninverting() {
        RemoteCache remoteCache = ClusteredIT.createQueryableCache(this.SERVER_TEST, this.indexed);
        remoteCache.put((Object)1, (Object)this.createUser1());
        remoteCache.put((Object)2, (Object)this.createUser2());
        QueryFactory qf = Search.getQueryFactory(remoteCache);
        Query query = qf.create("FROM sample_bank_account.User WHERE name = 'John' ORDER BY id ASC");
        Assert.assertEquals((long)0L, (long)query.execute().list().size());
    }

    @Test
    public void testIteratorWithQuery() {
        RemoteCache remoteCache = ClusteredIT.createQueryableCache(this.SERVER_TEST, this.indexed);
        remoteCache.put((Object)1, (Object)this.createUser1());
        remoteCache.put((Object)2, (Object)this.createUser2());
        QueryFactory qf = Search.getQueryFactory(remoteCache);
        Query simpleQuery = qf.create("FROM sample_bank_account.User WHERE name = 'Tom'");
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>(1);
        try (CloseableIterator iter = remoteCache.retrieveEntriesByQuery(simpleQuery, null, 3);){
            while (iter.hasNext()) {
                entries.add((Map.Entry)iter.next());
            }
        }
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertEquals((Object)"Cat", (Object)((User)((Map.Entry)entries.get(0)).getValue()).getSurname());
    }

    @Test
    public void testIteratorWithQueryAndProjections() {
        RemoteCache remoteCache = ClusteredIT.createQueryableCache(this.SERVER_TEST, this.indexed);
        remoteCache.put((Object)1, (Object)this.createUser1());
        remoteCache.put((Object)2, (Object)this.createUser2());
        QueryFactory qf = Search.getQueryFactory(remoteCache);
        Query simpleQuery = qf.create("SELECT surname, name FROM sample_bank_account.User WHERE name = 'Tom'");
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>(1);
        try (CloseableIterator iter = remoteCache.retrieveEntriesByQuery(simpleQuery, null, 3);){
            while (iter.hasNext()) {
                entries.add((Map.Entry)iter.next());
            }
        }
        Assert.assertEquals((long)1L, (long)entries.size());
        Object[] projections = (Object[])((Map.Entry)entries.get(0)).getValue();
        Assert.assertEquals((Object)"Cat", (Object)projections[0]);
        Assert.assertEquals((Object)"Tom", (Object)projections[1]);
    }

    @Test
    public void testQueryViaRest() throws IOException {
        RemoteCache remoteCache = ClusteredIT.createQueryableCache(this.SERVER_TEST, this.indexed);
        remoteCache.put((Object)1, (Object)this.createUser1());
        remoteCache.put((Object)2, (Object)this.createUser2());
        String query = "FROM sample_bank_account.User WHERE name='Adrian'";
        RestClient restClient = this.SERVER_TEST.newRestClient(new RestClientConfigurationBuilder());
        RestResponse response = (RestResponse)Common.sync(restClient.cache(this.SERVER_TEST.getMethodName()).query(query));
        JsonNode results = new ObjectMapper().readTree(response.getBody());
        Assert.assertEquals((long)1L, (long)results.get("total_results").asInt());
    }

    @Test
    public void testManyInClauses() {
        RemoteCache remoteCache = ClusteredIT.createQueryableCache(this.SERVER_TEST, this.indexed);
        remoteCache.put((Object)1, (Object)this.createUser1());
        remoteCache.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)remoteCache.get((Object)1);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(remoteCache);
        HashSet<String> values = new HashSet<String>();
        values.add("Tom");
        for (int i = 0; i < 1024; ++i) {
            values.add("test" + i);
        }
        Query query = qf.from(User.class).having("name").in(values).build();
        List list = query.execute().list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    @Test
    public void testWayTooManyInClauses() {
        RemoteCache remoteCache = ClusteredIT.createQueryableCache(this.SERVER_TEST, this.indexed);
        if (this.indexed) {
            this.expectedException.expect(HotRodClientException.class);
            this.expectedException.expectMessage("org.apache.lucene.search.BooleanQuery$TooManyClauses: maxClauseCount is set to 1025");
        }
        HashSet<String> values = new HashSet<String>();
        for (int i = 0; i < 1026; ++i) {
            values.add("test" + i);
        }
        QueryFactory qf = Search.getQueryFactory(remoteCache);
        Query query = qf.from(User.class).having("name").in(values).build();
        query.execute();
    }

    private User createUser1() {
        User user = new User();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singleton(12));
        Address address = new Address();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private User createUser2() {
        User user = new User();
        user.setId(2);
        user.setName("Adrian");
        user.setSurname("Nistor");
        user.setGender(User.Gender.MALE);
        Address address = new Address();
        address.setStreet("Old Street");
        address.setPostCode("XYZ");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private void assertUser1(User user) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((long)1L, (long)user.getId());
        Assert.assertEquals((Object)"Tom", (Object)user.getName());
        Assert.assertEquals((Object)"Cat", (Object)user.getSurname());
        Assert.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        Assert.assertNotNull((Object)user.getAccountIds());
        Assert.assertEquals((long)1L, (long)user.getAccountIds().size());
        Assert.assertTrue((boolean)user.getAccountIds().contains(12));
        Assert.assertNotNull((Object)user.getAddresses());
        Assert.assertEquals((long)1L, (long)user.getAddresses().size());
        Assert.assertEquals((Object)"Dark Alley", (Object)((Address)user.getAddresses().get(0)).getStreet());
        Assert.assertEquals((Object)"1234", (Object)((Address)user.getAddresses().get(0)).getPostCode());
    }
}

