/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.IOException;
import java.util.function.Function;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RestRouter {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testRestRouting() throws IOException {
        Function<String, RestClientConfigurationBuilder> cfgFromCtx = c -> new RestClientConfigurationBuilder().contextPath(c);
        try (RestClient restCtx = this.SERVER_TEST.newRestClient(cfgFromCtx.apply("/rest"));
             RestClient invalidCtx = this.SERVER_TEST.newRestClient(cfgFromCtx.apply("/invalid"));
             RestClient emptyCtx = this.SERVER_TEST.newRestClient(cfgFromCtx.apply("/"));){
            String body = ((RestResponse)Common.sync(restCtx.server().info())).getBody();
            Assert.assertTrue((String)body, (boolean)body.contains("version"));
            Assert.assertEquals((long)404L, (long)((RestResponse)Common.sync(emptyCtx.server().info())).getStatus());
            Assert.assertEquals((long)404L, (long)((RestResponse)Common.sync(invalidCtx.server().info())).getStatus());
        }
    }
}

