/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.infinispan.commons.test.Eventually;
import org.infinispan.server.functional.XSiteIT;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class XSiteHotRodCacheOperations {
    @ClassRule
    public static final InfinispanServerRule LON_SERVERS = XSiteIT.LON_SERVERS;
    @ClassRule
    public static final InfinispanServerRule NYC_SERVERS = XSiteIT.NYC_SERVERS;
    private static final String LON_CACHE_XML_CONFIG = "<infinispan><cache-container>  <distributed-cache-configuration name=\"%s\">     <backups>        <backup site=\"NYC\" strategy=\"ASYNC\"/>     </backups>  </distributed-cache-configuration></cache-container></infinispan>";
    @Rule
    public InfinispanServerTestMethodRule LON_SERVER_TEST = new InfinispanServerTestMethodRule(XSiteIT.LON_SERVERS);
    @Rule
    public InfinispanServerTestMethodRule NYC_SERVER_TEST = new InfinispanServerTestMethodRule(XSiteIT.NYC_SERVERS);

    @Test
    public void testHotRodOperations() {
        String lonXML = String.format(LON_CACHE_XML_CONFIG, this.LON_SERVER_TEST.getMethodName());
        RemoteCache lonCache = ((HotRodTestClientDriver)this.LON_SERVER_TEST.hotrod().withServerConfiguration(new XMLStringConfiguration(lonXML))).create();
        RemoteCache nycCache = this.NYC_SERVER_TEST.hotrod().create();
        lonCache.put((Object)"k1", (Object)"v1");
        nycCache.put((Object)"k2", (Object)"v2");
        Eventually.eventuallyEquals((Object)"v1", () -> (String)lonCache.get((Object)"k1"));
        Eventually.eventuallyEquals((Object)"v1", () -> (String)nycCache.get((Object)"k1"));
        Eventually.eventuallyEquals(null, () -> (String)lonCache.get((Object)"k2"));
        Eventually.eventuallyEquals((Object)"v2", () -> (String)nycCache.get((Object)"k2"));
    }
}

