/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.infinispan.client.hotrod.security.BasicCallbackHandler;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.security.AuthorizationPermission;

public class Common {
    private static final boolean IS_IBM = System.getProperty("java.vendor").contains("IBM");
    public static final Map<String, User> USER_MAP;
    public static final Collection<Object[]> SASL_MECHS;
    public static final Collection<Object[]> SASL_KERBEROS_MECHS;
    public static final Collection<Object[]> HTTP_MECHS;
    public static final Collection<Object[]> HTTP_KERBEROS_MECHS;
    public static final Collection<Protocol> HTTP_PROTOCOLS;

    public static <T> T sync(CompletionStage<T> stage) {
        return (T)Exceptions.unchecked(() -> stage.toCompletableFuture().get(5L, TimeUnit.SECONDS));
    }

    public static <T> T sync(CompletionStage<T> stage, long timeout, TimeUnit timeUnit) {
        return (T)Exceptions.unchecked(() -> stage.toCompletableFuture().get(timeout, timeUnit));
    }

    public static Subject createSubject(String principal, String realm, char[] password) {
        return (Subject)Exceptions.unchecked(() -> {
            LoginContext context = new LoginContext("KDC", null, (CallbackHandler)new BasicCallbackHandler(principal, realm, password), Common.createJaasConfiguration(false));
            context.login();
            return context.getSubject();
        });
    }

    private static Configuration createJaasConfiguration(final boolean server) {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                if (!"KDC".equals(name)) {
                    throw new IllegalArgumentException(String.format("Unexpected name '%s'", name));
                }
                AppConfigurationEntry[] entries = new AppConfigurationEntry[1];
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("refreshKrb5Config", "true");
                if (IS_IBM) {
                    options.put("noAddress", "true");
                    options.put("credsType", server ? "acceptor" : "initiator");
                    entries[0] = new AppConfigurationEntry("com.ibm.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                } else {
                    options.put("storeKey", "true");
                    options.put("isInitiator", server ? "false" : "true");
                    entries[0] = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                }
                return entries;
            }
        };
    }

    static {
        HTTP_PROTOCOLS = Arrays.asList(Protocol.values());
        USER_MAP = new HashMap<String, User>();
        USER_MAP.put("admin", new User("admin", "adminPassword", AuthorizationPermission.ALL.name()));
        USER_MAP.put("supervisor", new User("supervisorPassword", AuthorizationPermission.ALL_READ.name(), AuthorizationPermission.ALL_WRITE.name()));
        USER_MAP.put("reader", new User("reader", "readerPassword", AuthorizationPermission.ALL_READ.name()));
        USER_MAP.put("writer", new User("writer", "writerPassword", AuthorizationPermission.ALL_WRITE.name()));
        USER_MAP.put("unprivileged", new User("unprivileged", "unprivilegedPassword", AuthorizationPermission.NONE.name()));
        USER_MAP.put("executor", new User("executor", "executorPassword", AuthorizationPermission.EXEC.name()));
        SASL_MECHS = new ArrayList<Object[]>();
        SASL_MECHS.add(new Object[]{""});
        SASL_MECHS.add(new Object[]{"PLAIN"});
        SASL_MECHS.add(new Object[]{"DIGEST-MD5"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA-512"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA-384"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA-256"});
        SASL_MECHS.add(new Object[]{"DIGEST-SHA"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-512"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-384"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-256"});
        SASL_MECHS.add(new Object[]{"SCRAM-SHA-1"});
        SASL_KERBEROS_MECHS = new ArrayList<Object[]>();
        SASL_KERBEROS_MECHS.add(new Object[]{""});
        SASL_KERBEROS_MECHS.add(new Object[]{"GSSAPI"});
        SASL_KERBEROS_MECHS.add(new Object[]{"GS2-KRB5"});
        HTTP_MECHS = new ArrayList<Object[]>();
        HTTP_MECHS.add(new Object[]{""});
        HTTP_MECHS.add(new Object[]{"BASIC"});
        HTTP_MECHS.add(new Object[]{"DIGEST"});
        HTTP_KERBEROS_MECHS = new ArrayList<Object[]>();
        HTTP_KERBEROS_MECHS.add(new Object[]{""});
        HTTP_KERBEROS_MECHS.add(new Object[]{"SPNEGO"});
    }

    public static class User {
        final String username;
        final char[] password;
        final Iterable<String> groups;

        public User(String username, String password, String ... groups) {
            this.username = username;
            this.password = password.toCharArray();
            this.groups = Arrays.asList(groups);
        }
    }
}

