/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.persistence;

import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.encoding.DataConversion;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.util.concurrent.CompletableFutures;

public class CustomNonBlockingStore
implements NonBlockingStore<String, String> {
    private MarshallableEntryFactory<String, String> marshallableEntryFactory;
    private DataConversion keyDataConversion;
    private DataConversion valueDataConversion;

    public CompletionStage<Void> start(InitializationContext ctx) {
        this.marshallableEntryFactory = ctx.getMarshallableEntryFactory();
        AdvancedCache object = ctx.getCache().getAdvancedCache().withMediaType("application/x-java-object", "application/x-java-object");
        this.keyDataConversion = object.getKeyDataConversion();
        this.valueDataConversion = object.getValueDataConversion();
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> stop() {
        return CompletableFutures.completedNull();
    }

    public Set<NonBlockingStore.Characteristic> characteristics() {
        return EnumSet.of(NonBlockingStore.Characteristic.READ_ONLY);
    }

    public CompletionStage<MarshallableEntry<String, String>> load(int segment, Object storageKey) {
        Object objectKey = this.keyDataConversion.fromStorage(storageKey);
        String value = "Hello " + objectKey;
        Object storageValue = this.valueDataConversion.toStorage((Object)value);
        return CompletableFuture.completedFuture(this.marshallableEntryFactory.create(storageKey, storageValue));
    }

    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends String, ? extends String> entry) {
        throw new UnsupportedOperationException("This store doesn't support write!");
    }

    public CompletionStage<Boolean> delete(int segment, Object key) {
        throw new UnsupportedOperationException("This store doesn't support delete!");
    }

    public CompletionStage<Void> clear() {
        throw new UnsupportedOperationException("This store doesn't support clear!");
    }
}

