/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.AnnotationUtils;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.infinispan.commons.util.Util;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LdapServerRule
implements TestRule {
    public static final int KDC_PORT = 6088;
    public static final int LDAP_PORT = 10389;
    public static final int LDAPS_PORT = 10636;
    public static final String DEFAULT_LDIF = "ldif/infinispan.ldif";
    public static final String DOMAIN = "dc=infinispan,dc=org";
    public static final String REALM = "INFINISPAN.ORG";
    private final String initLDIF;
    private final InfinispanServerRule infinispanServerRule;
    private DirectoryService directoryService;
    private LdapServer ldapServer;
    private KdcServer kdcServer;
    private boolean withKdc;

    public LdapServerRule(InfinispanServerRule infinispanServerRule) {
        this(infinispanServerRule, DEFAULT_LDIF, false);
    }

    public LdapServerRule(InfinispanServerRule infinispanServerRule, String initLDIF, boolean withKdc) {
        this.infinispanServerRule = infinispanServerRule;
        this.initLDIF = initLDIF;
        this.withKdc = withKdc;
        if (withKdc) {
            infinispanServerRule.registerConfigurationEnhancer(configDir -> {
                LdapServerRule.generateKeyTab(new File((File)configDir, "hotrod.keytab"), "hotrod/datagrid@INFINISPAN.ORG", "hotrodPassword");
                LdapServerRule.generateKeyTab(new File((File)configDir, "http.keytab"), "HTTP/localhost@INFINISPAN.ORG", "httpPassword");
            });
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LdapServerRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    LdapServerRule.this.after();
                }
            }
        };
    }

    private void before() {
        Exceptions.unchecked(() -> {
            this.createDs();
            this.createLdap();
            this.ldapServer.start();
            if (this.withKdc) {
                this.createKdc();
                this.kdcServer.start();
            }
        });
    }

    private void after() {
        try {
            if (this.kdcServer != null) {
                this.kdcServer.stop();
                this.kdcServer = null;
            }
            this.ldapServer.stop();
            this.directoryService.shutdown();
        }
        catch (Exception exception) {
        }
        finally {
            Util.recursiveFileRemove((File)this.directoryService.getInstanceLayout().getInstanceDirectory());
        }
        ThreadLeakChecker.ignoreThreadsContaining((String)"pool-.*thread-");
    }

    @CreateDS(name="InfinispanDS", partitions={@CreatePartition(name="infinispan", suffix="dc=infinispan,dc=org", contextEntry=@ContextEntry(entryLdif="dn: dc=infinispan,dc=org\ndc: infinispan\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou"), @CreateIndex(attribute="uid")})})
    public void createDs() throws Exception {
        this.directoryService = DSAnnotationProcessor.getDirectoryService();
        this.directoryService.getChangeLog().setEnabled(false);
        this.directoryService.addLast((Interceptor)new KeyDerivationInterceptor());
    }

    @CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10389, address="0.0.0.0")})
    public void createLdap() throws Exception {
        SchemaManager schemaManager = this.directoryService.getSchemaManager();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.initLDIF);){
            for (LdifEntry ldifEntry : new LdifReader(is)) {
                this.directoryService.getAdminSession().add((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
            }
        }
        CreateLdapServer createLdapServer = (CreateLdapServer)AnnotationUtils.getInstance(CreateLdapServer.class);
        this.ldapServer = ServerAnnotationProcessor.instantiateLdapServer((CreateLdapServer)createLdapServer, (DirectoryService)this.directoryService);
        this.ldapServer.setKeystoreFile(this.infinispanServerRule.getServerDriver().getCertificateFile("server").getAbsolutePath());
        this.ldapServer.setCertificatePassword("secret");
        TcpTransport ldaps = new TcpTransport(10636);
        ldaps.enableSSL(true);
        this.ldapServer.addTransports(new Transport[]{ldaps});
    }

    private void createKdc() {
        KdcServer kdcServer = new KdcServer();
        kdcServer.setServiceName("TestKDCServer");
        kdcServer.setSearchBaseDn(DOMAIN);
        KerberosConfig config = kdcServer.getConfig();
        config.setServicePrincipal("krbtgt/INFINISPAN.ORG@INFINISPAN.ORG");
        config.setPrimaryRealm(REALM);
        config.setMaximumTicketLifetime(86400000L);
        config.setMaximumRenewableLifetime(604800000L);
        config.setPaEncTimestampRequired(false);
        UdpTransport udp = new UdpTransport("0.0.0.0", 6088);
        kdcServer.addTransports(new Transport[]{udp});
        kdcServer.setDirectoryService(this.directoryService);
        this.kdcServer = kdcServer;
    }

    public static String generateKeyTab(File keyTabFile, String ... credentials) {
        ArrayList<KeytabEntry> entries = new ArrayList<KeytabEntry>();
        KerberosTime ktm = new KerberosTime();
        int i = 0;
        while (i < credentials.length) {
            String principal = credentials[i++];
            String password = credentials[i++];
            for (Map.Entry keyEntry : KerberosKeyFactory.getKerberosKeys((String)principal, (String)password).entrySet()) {
                EncryptionKey key = (EncryptionKey)keyEntry.getValue();
                entries.add(new KeytabEntry(principal, 1, ktm, (byte)key.getKeyVersion(), key));
            }
        }
        Keytab keyTab = Keytab.getInstance();
        keyTab.setEntries(entries);
        try {
            keyTab.write(keyTabFile);
            return keyTabFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create keytab: " + keyTabFile, e);
        }
    }
}

