/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestCacheManagerClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestClusterClient;
import org.infinispan.client.rest.RestCounterClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestTaskClient;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.configuration.Element;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.server.functional.AbstractMultiClusterIT;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.CompletionStages;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BackupManagerIT
extends AbstractMultiClusterIT {
    static final File WORKING_DIR = new File(CommonsTestingUtil.tmpDirectory(BackupManagerIT.class));
    static final int NUM_ENTRIES = 10;

    public BackupManagerIT() {
        super("configuration/ClusteredServerTest.xml");
    }

    @BeforeClass
    public static void setup() {
        WORKING_DIR.mkdirs();
    }

    @AfterClass
    public static void teardown() {
        Util.recursiveFileRemove((File)WORKING_DIR);
    }

    @Test
    public void testManagerBackupUpload() throws Exception {
        String name = "testManagerBackup";
        this.performTest(client -> {
            RestCacheManagerClient cm = client.cacheManager("clustered");
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.createBackup(name));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            return this.awaitOk(() -> cm.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            RestCacheManagerClient cm = client.cacheManager("clustered");
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.restore(name, zip));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            return this.awaitCreated(() -> cm.getRestore(name));
        }, this::assertWildcardContent);
    }

    @Test
    public void testManagerBackupFromFile() throws Exception {
        String name = "testManagerBackup";
        this.performTest(client -> {
            RestCacheManagerClient cm = client.cacheManager("clustered");
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.createBackup(name));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            response.close();
            return this.awaitOk(() -> cm.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            RestCacheManagerClient cm = client.cacheManager("clustered");
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.restore(name, zip.getPath(), null));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            return this.awaitCreated(() -> cm.getRestore(name));
        }, this::assertWildcardContent);
    }

    @Test
    public void testManagerBackupParameters() throws Exception {
        String name = "testManagerBackupParameters";
        this.performTest(client -> {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("caches", Collections.singletonList("*"));
            params.put("counters", Collections.singletonList("weak-volatile"));
            RestCacheManagerClient cm = client.cacheManager("clustered");
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.createBackup(name, params));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            return this.awaitOk(() -> cm.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("caches", Collections.singletonList("cache1"));
            params.put("counters", Collections.singletonList("*"));
            RestCacheManagerClient cm = client.cacheManager("clustered");
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.restore(name, zip, params));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            return this.awaitCreated(() -> cm.getRestore(name));
        }, client -> {
            Assert.assertEquals((Object)"[\"___protobuf_metadata\",\"memcachedCache\",\"cache1\",\"___script_cache\"]", (Object)((RestResponse)FunctionalTestUtils.await((CompletionStage)client.caches())).getBody());
            Assert.assertEquals((Object)"[\"weak-volatile\"]", (Object)((RestResponse)FunctionalTestUtils.await((CompletionStage)client.counters())).getBody());
            Assert.assertEquals((long)404L, (long)((RestResponse)FunctionalTestUtils.await((CompletionStage)client.schemas().get("schema.proto"))).getStatus());
            Assert.assertEquals((Object)"[]", (Object)((RestResponse)FunctionalTestUtils.await((CompletionStage)client.tasks().list(RestTaskClient.ResultType.USER))).getBody());
        });
    }

    @Test
    public void testCreateDuplicateBackupResources() throws Exception {
        String backupName = "testCreateDuplicateBackupResources";
        this.startSourceCluster();
        RestClient client = this.source.getClient();
        this.populateContainer(client);
        RestCacheManagerClient cm = client.cacheManager("clustered");
        RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.createBackup(backupName));
        Assert.assertEquals((long)202L, (long)response.getStatus());
        response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.createBackup(backupName));
        Assert.assertEquals((long)409L, (long)response.getStatus());
        response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.deleteBackup(backupName));
        Assert.assertEquals((long)202L, (long)response.getStatus());
        this.awaitStatus(() -> cm.deleteBackup(backupName), 202, 404);
        response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.createBackup(backupName));
        Assert.assertEquals((long)202L, (long)response.getStatus());
        this.awaitOk(() -> cm.getBackup(backupName, false));
        response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.deleteBackup(backupName));
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void testManagerRestoreParameters() throws Exception {
        String name = "testManagerRestoreParameters";
        this.performTest(client -> {
            RestCacheManagerClient cm = client.cacheManager("clustered");
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.createBackup(name));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            return this.awaitOk(() -> cm.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("tasks", Collections.singletonList("test.js"));
            RestCacheManagerClient cm = client.cacheManager("clustered");
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cm.restore(name, zip, params));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            return this.awaitCreated(() -> cm.getRestore(name));
        }, client -> {
            List tasks = Json.read((String)((RestResponse)FunctionalTestUtils.await((CompletionStage)client.tasks().list(RestTaskClient.ResultType.USER))).getBody()).asJsonList();
            Assert.assertEquals((long)1L, (long)tasks.size());
            Assert.assertEquals((Object)"test.js", (Object)((Json)tasks.iterator().next()).at("name").asString());
            Assert.assertEquals((Object)"[\"___protobuf_metadata\",\"memcachedCache\",\"___script_cache\"]", (Object)((RestResponse)FunctionalTestUtils.await((CompletionStage)client.caches())).getBody());
            Assert.assertEquals((Object)"[]", (Object)((RestResponse)FunctionalTestUtils.await((CompletionStage)client.counters())).getBody());
            Assert.assertEquals((long)404L, (long)((RestResponse)FunctionalTestUtils.await((CompletionStage)client.schemas().get("schema.proto"))).getStatus());
        });
    }

    @Test
    public void testClusterBackupUpload() throws Exception {
        String name = "testClusterBackup";
        this.performTest(client -> {
            RestClusterClient cluster = client.cluster();
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cluster.createBackup(name));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            return this.awaitOk(() -> cluster.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            RestClusterClient c = client.cluster();
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)c.restore(name, zip));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            return this.awaitCreated(() -> c.getRestore(name));
        }, this::assertWildcardContent);
    }

    @Test
    public void testClusterBackupFromFile() throws Exception {
        String name = "testClusterBackup";
        this.performTest(client -> {
            RestClusterClient cluster = client.cluster();
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)cluster.createBackup(name));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            return this.awaitOk(() -> cluster.getBackup(name, false));
        }, client -> (RestResponse)FunctionalTestUtils.await((CompletionStage)client.cacheManager("clustered").deleteBackup(name)), (zip, client) -> {
            RestClusterClient c = client.cluster();
            RestResponse response = (RestResponse)FunctionalTestUtils.await((CompletionStage)c.restore(name, zip.getPath()));
            Assert.assertEquals((long)202L, (long)response.getStatus());
            return this.awaitCreated(() -> c.getRestore(name));
        }, this::assertWildcardContent);
    }

    private RestResponse awaitOk(Supplier<CompletionStage<RestResponse>> request) {
        return this.awaitStatus(request, 202, 200);
    }

    private RestResponse awaitCreated(Supplier<CompletionStage<RestResponse>> request) {
        return this.awaitStatus(request, 202, 201);
    }

    private RestResponse awaitStatus(Supplier<CompletionStage<RestResponse>> request, int pendingStatus, int completeStatus) {
        RestResponse response;
        int count = 0;
        while ((response = (RestResponse)FunctionalTestUtils.await(request.get())).getStatus() == pendingStatus || count++ < 100) {
            TestingUtil.sleepThread((long)10L);
            response.close();
        }
        Assert.assertEquals((long)completeStatus, (long)response.getStatus());
        return response;
    }

    private void performTest(Function<RestClient, RestResponse> backupAndDownload, Function<RestClient, RestResponse> delete, BiFunction<File, RestClient, RestResponse> restore, Consumer<RestClient> assertTargetContent) throws Exception {
        this.startSourceCluster();
        RestClient client = this.source.getClient();
        this.populateContainer(client);
        RestResponse getResponse = backupAndDownload.apply(client);
        String fileName = getResponse.getHeader("Content-Disposition").split("=")[1];
        RestResponse deleteResponse = delete.apply(client);
        Assert.assertEquals((long)204L, (long)deleteResponse.getStatus());
        deleteResponse.close();
        Thread.sleep(50L);
        this.assertNoServerBackupFilesExist(this.source);
        this.stopSourceCluster();
        this.startTargetCluster();
        client = this.target.getClient();
        File backupZip = new File(WORKING_DIR, fileName);
        try (InputStream is = getResponse.getBodyAsStream();){
            Files.copy(is, backupZip.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        getResponse.close();
        RestResponse restoreResponse = restore.apply(backupZip, client);
        Assert.assertEquals((String)restoreResponse.getBody(), (long)201L, (long)restoreResponse.getStatus());
        restoreResponse.close();
        assertTargetContent.accept(this.target.getClient(1));
        this.assertNoServerBackupFilesExist(this.target);
        this.stopTargetCluster();
    }

    private void populateContainer(RestClient client) throws Exception {
        String cacheName = "cache1";
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        this.createCache(cacheName, builder, client);
        RestCacheClient cache = client.cache(cacheName);
        for (int i = 0; i < 10; ++i) {
            CompletionStages.join((CompletionStage)cache.put(String.valueOf(i), "Val-" + i));
        }
        Assert.assertEquals((long)10L, (long)this.getCacheSize(cacheName, client));
        this.createCounter("weak-volatile", Element.WEAK_COUNTER, Storage.VOLATILE, client, 0L);
        this.createCounter("weak-persistent", Element.WEAK_COUNTER, Storage.PERSISTENT, client, -100L);
        this.createCounter("strong-volatile", Element.STRONG_COUNTER, Storage.VOLATILE, client, 50L);
        this.createCounter("strong-persistent", Element.STRONG_COUNTER, Storage.PERSISTENT, client, 0L);
        this.addSchema(client);
        try (InputStream is = BackupManagerIT.class.getResourceAsStream("/scripts/test.js");){
            String script = CommonsTestingUtil.loadFileAsString((InputStream)is);
            RestResponse rsp = (RestResponse)FunctionalTestUtils.await((CompletionStage)client.tasks().uploadScript("test.js", RestEntity.create((MediaType)MediaType.APPLICATION_JAVASCRIPT, (String)script)));
            Assert.assertEquals((long)200L, (long)rsp.getStatus());
        }
    }

    private void assertWildcardContent(RestClient client) {
        String cacheName = "cache1";
        RestCacheClient cache = client.cache(cacheName);
        Assert.assertEquals((Object)Integer.toString(10), (Object)((RestResponse)FunctionalTestUtils.await((CompletionStage)cache.size())).getBody());
        for (int i = 0; i < 10; ++i) {
            String index = String.valueOf(i);
            Assert.assertEquals((Object)("Val-" + index), (Object)((RestResponse)CompletionStages.join((CompletionStage)cache.get(index))).getBody());
        }
        this.assertCounter(client, "weak-volatile", Element.WEAK_COUNTER, Storage.VOLATILE, 0L);
        this.assertCounter(client, "weak-persistent", Element.WEAK_COUNTER, Storage.PERSISTENT, -100L);
        this.assertCounter(client, "strong-volatile", Element.STRONG_COUNTER, Storage.VOLATILE, 50L);
        this.assertCounter(client, "strong-persistent", Element.STRONG_COUNTER, Storage.PERSISTENT, 0L);
        RestResponse rsp = (RestResponse)FunctionalTestUtils.await((CompletionStage)client.schemas().get("schema.proto"));
        Assert.assertEquals((long)200L, (long)rsp.getStatus());
        Assert.assertTrue((boolean)rsp.getBody().contains("message Person"));
        rsp = (RestResponse)FunctionalTestUtils.await((CompletionStage)client.tasks().list(RestTaskClient.ResultType.USER));
        Assert.assertEquals((long)200L, (long)rsp.getStatus());
        Json json = Json.read((String)rsp.getBody());
        Assert.assertTrue((boolean)json.isArray());
        List tasks = json.asJsonList();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"test.js", (Object)((Json)tasks.get(0)).at("name").asString());
    }

    private void createCounter(String name, Element type, Storage storage, RestClient client, long delta) {
        String config = String.format("{\n    \"%s\":{\n        \"initial-value\":0,\n        \"storage\":\"%s\"\n    }\n}", type, storage.toString());
        RestCounterClient counterClient = client.counter(name);
        RestResponse rsp = (RestResponse)FunctionalTestUtils.await((CompletionStage)counterClient.create(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)config)));
        Assert.assertEquals((long)200L, (long)rsp.getStatus());
        if (delta != 0L) {
            rsp = (RestResponse)FunctionalTestUtils.await((CompletionStage)counterClient.add(delta));
            Assert.assertEquals((String)name, (long)(name.contains("strong") ? 200L : 204L), (long)rsp.getStatus());
            Assert.assertNotNull((Object)rsp.getBody());
        }
    }

    private void assertCounter(RestClient client, String name, Element type, Storage storage, long expectedValue) {
        RestResponse rsp = (RestResponse)FunctionalTestUtils.await((CompletionStage)client.counter(name).configuration());
        Assert.assertEquals((long)200L, (long)rsp.getStatus());
        String content = rsp.getBody();
        Json config = Json.read((String)content).at(type.toString());
        Assert.assertEquals((Object)name, (Object)config.at("name").asString());
        Assert.assertEquals((Object)storage.toString(), (Object)config.at("storage").asString());
        Assert.assertEquals((long)0L, (long)config.at("initial-value").asInteger());
        rsp = (RestResponse)FunctionalTestUtils.await((CompletionStage)client.counter(name).get());
        Assert.assertEquals((long)200L, (long)rsp.getStatus());
        Assert.assertEquals((long)expectedValue, (long)Long.parseLong(rsp.getBody()));
    }

    private void assertNoServerBackupFilesExist(AbstractMultiClusterIT.Cluster cluster) {
        for (int i = 0; i < 2; ++i) {
            Path root = cluster.driver.getRootDir().toPath();
            File workingDir = root.resolve(Integer.toString(i)).resolve("data").resolve("backups").toFile();
            Assert.assertTrue((boolean)workingDir.isDirectory());
            Object[] files = workingDir.list();
            Assert.assertNotNull((Object)files);
            Assert.assertEquals((String)Arrays.toString(files), (long)0L, (long)files.length);
        }
    }
}

