/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.stream.IntStream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.Eventually;
import org.infinispan.server.functional.XSiteIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.junit4.InfinispanXSiteServerRule;
import org.infinispan.server.test.junit4.InfinispanXSiteServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class XSiteHotRodCacheOperations {
    @ClassRule
    public static final InfinispanXSiteServerRule SERVERS = XSiteIT.SERVERS;
    @Rule
    public InfinispanXSiteServerTestMethodRule SERVER_TEST = new InfinispanXSiteServerTestMethodRule(SERVERS);

    @Test
    public void testHotRodOperations() {
        String lonXML = String.format("<infinispan><cache-container>  <replicated-cache name=\"%s\">     <backups>        <backup site=\"NYC\" strategy=\"ASYNC\"/>     </backups>  </replicated-cache></cache-container></infinispan>", this.SERVER_TEST.getMethodName());
        RemoteCache lonCache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod("LON").withServerConfiguration(new XMLStringConfiguration(lonXML))).create();
        RemoteCache nycCache = this.SERVER_TEST.hotrod("NYC").create();
        this.insertAndVerifyEntries((RemoteCache<String, String>)lonCache, (RemoteCache<String, String>)nycCache, false);
    }

    @Test
    public void testHotRodOperationsWithDifferentCacheName() {
        RemoteCache lonCache = this.SERVER_TEST.hotrod("LON").createRemoteCacheManager().administration().createCache("lon-cache", (BasicConfiguration)new XMLStringConfiguration("<infinispan><cache-container>  <replicated-cache name=\"lon-cache\">     <backups>        <backup site=\"NYC\" strategy=\"ASYNC\"/>     </backups>     <backup-for remote-cache=\"nyc-cache\" remote-site=\"NYC\" />  </replicated-cache></cache-container></infinispan>"));
        RemoteCache nycCache = this.SERVER_TEST.hotrod("NYC").createRemoteCacheManager().administration().createCache("nyc-cache", (BasicConfiguration)new XMLStringConfiguration("<infinispan><cache-container>  <replicated-cache name=\"nyc-cache\">     <backups>        <backup site=\"LON\" strategy=\"ASYNC\"/>     </backups>     <backup-for remote-cache=\"lon-cache\" remote-site=\"LON\" />  </replicated-cache></cache-container></infinispan>"));
        this.insertAndVerifyEntries((RemoteCache<String, String>)lonCache, (RemoteCache<String, String>)nycCache, true);
    }

    @Test
    public void testHotRodOperationsWithOffHeapSingleFileStore() {
        String lonXML = String.format("<infinispan><cache-container statistics=\"true\"><distributed-cache name=\"%s\" owners=\"2\" mode=\"ASYNC\" remote-timeout=\"25000\" start=\"EAGER\" statistics=\"true\">        <backups>            <backup site=\"NYC\" strategy=\"ASYNC\" timeout=\"30000\">                <take-offline after-failures=\"-1\" min-wait=\"60000\"/>            </backup>        </backups>        <memory storage=\"OFF_HEAP\" max-count=\"100\" when-full=\"REMOVE\"/>        <persistence passivation=\"true\">     <file-store max-entries=\"100\" shared=\"false\" preload=\"true\" purge=\"false\" fetch-state=\"true\"/>  </persistence>  </distributed-cache></cache-container></infinispan>", this.SERVER_TEST.getMethodName());
        RemoteCache lonCache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod("LON").withServerConfiguration(new XMLStringConfiguration(lonXML))).create();
        RemoteCache nycCache = this.SERVER_TEST.hotrod("NYC").create();
        Assert.assertEquals((long)0L, (long)this.getTotalMemoryEntries(lonXML));
        IntStream.range(0, 300).forEach(i -> lonCache.put((Object)i, (Object)i));
        Eventually.eventuallyEquals((Object)300, () -> nycCache.size());
        Assert.assertEquals((long)100L, (long)this.getTotalMemoryEntries(lonXML));
    }

    private int getTotalMemoryEntries(String lonXML) {
        RestClient restClient = ((RestTestClientDriver)this.SERVER_TEST.rest("LON").withServerConfiguration(new XMLStringConfiguration(lonXML))).get();
        RestCacheClient client = restClient.cache(this.SERVER_TEST.getMethodName());
        Json json = Json.read((String)((RestResponse)Common.sync(client.stats())).getBody());
        return ((Json)json.asJsonMap().get("current_number_of_entries_in_memory")).asInteger();
    }

    private void insertAndVerifyEntries(RemoteCache<String, String> lonCache, RemoteCache<String, String> nycCache, boolean allSitesBackup) {
        lonCache.put((Object)"k1", (Object)"v1");
        nycCache.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((Object)"v1", (Object)lonCache.get((Object)"k1"));
        Eventually.eventuallyEquals((Object)"v1", () -> (String)nycCache.get((Object)"k1"));
        if (allSitesBackup) {
            Eventually.eventuallyEquals((Object)"v2", () -> (String)lonCache.get((Object)"k2"));
        } else {
            Assert.assertEquals(null, (Object)lonCache.get((Object)"k2"));
        }
        Assert.assertEquals((Object)"v2", (Object)nycCache.get((Object)"k2"));
    }
}

