/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestMetricsClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RestMetricsResource {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testOpenMetrics() {
        RestMetricsClient metricsClient = this.SERVER_TEST.rest().create().metrics();
        RestResponse response = (RestResponse)Common.sync(metricsClient.metrics(true));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.contentType());
        String metricsText = response.getBody();
        String metricName = "cache_manager_default_cache_" + this.SERVER_TEST.getMethodName() + "_statistics_stores";
        Assert.assertTrue((boolean)metricsText.contains("# TYPE vendor_" + metricName + " gauge\n"));
        response = (RestResponse)Common.sync(metricsClient.metrics("vendor/" + metricName, true));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        metricsText = response.getBody();
        Assert.assertTrue((boolean)metricsText.contains("# TYPE vendor_" + metricName + " gauge\n"));
    }

    @Test
    public void testBaseAndVendorMetrics() {
        RestMetricsClient metricsClient = this.SERVER_TEST.rest().create().metrics();
        RestResponse response = (RestResponse)Common.sync(metricsClient.metrics("base/classloader.loadedClasses.count"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Json loadedClassesCountNode = Json.read((String)response.getBody());
        Assert.assertNotNull(loadedClassesCountNode.asJsonMap().get("classloader.loadedClasses.count"));
        int loadedClassesCount = loadedClassesCountNode.at("classloader.loadedClasses.count").asInteger();
        Assert.assertTrue((loadedClassesCount > 0 ? 1 : 0) != 0);
        response = (RestResponse)Common.sync(metricsClient.metrics("vendor/memoryPool.Metaspace.usage"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Json memoryPoolMetaspaceUsageNode = Json.read((String)response.getBody());
        Assert.assertNotNull(memoryPoolMetaspaceUsageNode.asJsonMap().get("memoryPool.Metaspace.usage"));
        int metaspaceUsage = memoryPoolMetaspaceUsageNode.at("memoryPool.Metaspace.usage").asInteger();
        Assert.assertTrue((metaspaceUsage > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMicroprofileMetrics() {
        RestClient client = this.SERVER_TEST.rest().create();
        RestMetricsClient metricsClient = client.metrics();
        String metricName = "cache_manager_default_cache_" + this.SERVER_TEST.getMethodName() + "_statistics_stores";
        RestResponse response = (RestResponse)Common.sync(metricsClient.metrics());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)response.contentType());
        String metricsJson = response.getBody();
        Json node = Json.read((String)metricsJson);
        Assert.assertNotNull((Object)node.at("base"));
        Assert.assertNotNull((Object)node.at("vendor"));
        Assert.assertNotNull((Object)node.at("application"));
        Assert.assertTrue((boolean)metricsJson.contains(metricName));
        response = (RestResponse)Common.sync(metricsClient.metrics("vendor/" + metricName));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        long totalStoresBefore = RestMetricsResource.streamNodeFields(Json.read((String)response.getBody())).map(e -> ((Json)e.getValue()).asLong()).reduce(0L, Long::sum);
        Assert.assertEquals((long)0L, (long)totalStoresBefore);
        RestCacheClient cache = client.cache(this.SERVER_TEST.getMethodName());
        int NUM_PUTS = 10;
        for (int i = 0; i < NUM_PUTS; ++i) {
            RestResponse putResp = (RestResponse)Common.sync(cache.put("k" + i, "v" + i));
            Assert.assertEquals((long)204L, (long)putResp.getStatus());
        }
        response = (RestResponse)Common.sync(metricsClient.metrics("vendor/" + metricName));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String metricJson = response.getBody();
        long totalStoresAfter = RestMetricsResource.streamNodeFields(Json.read((String)metricJson)).map(e -> ((Json)e.getValue()).asLong()).reduce(0L, Long::sum);
        Assert.assertEquals((long)NUM_PUTS, (long)totalStoresAfter);
        Common.sync(client.cache(this.SERVER_TEST.getMethodName()).delete());
        response = (RestResponse)Common.sync(metricsClient.metricsMetadata("vendor/" + metricName));
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response = (RestResponse)Common.sync(metricsClient.metricsMetadata("vendor/no_such_metric"));
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testMicroprofileTimerMetrics() {
        RestClient client = this.SERVER_TEST.rest().create();
        RestMetricsClient metricsClient = client.metrics();
        String metricName = "cache_manager_default_cache_" + this.SERVER_TEST.getMethodName() + "_statistics_store_times";
        RestResponse response = (RestResponse)Common.sync(metricsClient.metrics("vendor/" + metricName));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)response.contentType());
        long meanStoreTimesBefore = RestMetricsResource.streamNodeFields(Json.read((String)response.getBody()).at(metricName)).filter(e -> ((String)e.getKey()).startsWith("mean;")).map(e -> ((Json)e.getValue()).asLong()).reduce(0L, Long::sum);
        Assert.assertEquals((long)0L, (long)meanStoreTimesBefore);
        RestCacheClient cache = client.cache(this.SERVER_TEST.getMethodName());
        int NUM_PUTS = 10;
        for (int i = 0; i < NUM_PUTS; ++i) {
            RestResponse putResp = (RestResponse)Common.sync(cache.put("k" + i, "v" + i));
            Assert.assertEquals((long)204L, (long)putResp.getStatus());
        }
        response = (RestResponse)Common.sync(metricsClient.metrics("vendor/" + metricName));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        long meanStoreTimesAfter = RestMetricsResource.streamNodeFields(Json.read((String)response.getBody()).at(metricName)).filter(e -> ((String)e.getKey()).startsWith("mean;")).map(e -> ((Json)e.getValue()).asLong()).reduce(0L, Long::sum);
        Assert.assertTrue((meanStoreTimesAfter > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMicroprofileMetricsMetadata() {
        RestClient client = this.SERVER_TEST.rest().create();
        RestMetricsClient metricsClient = client.metrics();
        String metricName = "cache_manager_default_cache_" + this.SERVER_TEST.getMethodName() + "_statistics_stores";
        RestResponse response = (RestResponse)Common.sync(metricsClient.metricsMetadata());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)response.contentType());
        String metricsMetadataJson = response.getBody();
        Assert.assertTrue((boolean)metricsMetadataJson.contains(metricName));
        response = (RestResponse)Common.sync(metricsClient.metricsMetadata("vendor/" + metricName));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Json node = Json.read((String)response.getBody());
        Assert.assertNotNull((Object)node.at(metricName));
        Assert.assertEquals((Object)"gauge", (Object)node.at(metricName).at("type").asString());
        Assert.assertEquals((Object)"stores", (Object)node.at(metricName).at("displayName").asString());
        Common.sync(client.cache(this.SERVER_TEST.getMethodName()).delete());
        response = (RestResponse)Common.sync(metricsClient.metricsMetadata("vendor/" + metricName));
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    private static Stream<Map.Entry<String, Json>> streamNodeFields(Json node) {
        if (node == null) {
            throw new IllegalArgumentException("Input node cannot be null");
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(node.asJsonMap().entrySet().iterator(), 1024), false);
    }
}

