/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.concurrent.CompletionStage;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.Eventually;
import org.infinispan.server.functional.XSiteIT;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.infinispan.util.concurrent.CompletionStages;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class XSiteRestCacheOperations {
    @ClassRule
    public static final InfinispanServerRule LON_SERVERS = XSiteIT.LON_SERVERS;
    @ClassRule
    public static final InfinispanServerRule NYC_SERVERS = XSiteIT.NYC_SERVERS;
    private static final String LON_CACHE_XML_CONFIG = "<infinispan><cache-container>  <replicated-cache name=\"%s\">     <backups>        <backup site=\"NYC\" strategy=\"ASYNC\"/>     </backups>  </replicated-cache></cache-container></infinispan>";
    @Rule
    public InfinispanServerTestMethodRule LON_SERVER_TEST = new InfinispanServerTestMethodRule(XSiteIT.LON_SERVERS);
    @Rule
    public InfinispanServerTestMethodRule NYC_SERVER_TEST = new InfinispanServerTestMethodRule(XSiteIT.NYC_SERVERS);

    private static void assertStatus(int status, CompletionStage<RestResponse> stage) {
        Assert.assertEquals((long)status, (long)((RestResponse)CompletionStages.join(stage)).getStatus());
    }

    private static String bodyOf(CompletionStage<RestResponse> stage) {
        RestResponse rsp = (RestResponse)CompletionStages.join(stage);
        return rsp.getStatus() == 200 ? rsp.getBody() : null;
    }

    @Test
    public void testRestOperations() {
        String cacheName = this.LON_SERVER_TEST.getMethodName();
        String lonXML = String.format(LON_CACHE_XML_CONFIG, cacheName);
        RestClient lonClient = this.LON_SERVER_TEST.rest().get();
        RestClient nycClient = this.NYC_SERVER_TEST.rest().get();
        RestCacheClient lonCache = lonClient.cache(cacheName);
        RestCacheClient nycCache = nycClient.cache(cacheName);
        XSiteRestCacheOperations.assertStatus(200, lonCache.createWithConfiguration(RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)lonXML), new CacheContainerAdmin.AdminFlag[0]));
        XSiteRestCacheOperations.assertStatus(200, nycCache.createWithTemplate(DefaultTemplate.DIST_SYNC.getTemplateName(), new CacheContainerAdmin.AdminFlag[0]));
        XSiteRestCacheOperations.assertStatus(204, lonCache.put("k1", "v1"));
        XSiteRestCacheOperations.assertStatus(204, nycCache.put("k2", "v2"));
        Eventually.eventuallyEquals((Object)"v1", () -> XSiteRestCacheOperations.bodyOf(lonCache.get("k1")));
        Eventually.eventuallyEquals((Object)"v1", () -> XSiteRestCacheOperations.bodyOf(nycCache.get("k1")));
        Eventually.eventuallyEquals(null, () -> XSiteRestCacheOperations.bodyOf(lonCache.get("k2")));
        Eventually.eventuallyEquals((Object)"v2", () -> XSiteRestCacheOperations.bodyOf(nycCache.get("k2")));
    }
}

