/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.impl.okhttp.StringRestEntityOkHttp;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.test.core.AbstractInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.util.concurrent.CompletionStages;
import org.junit.After;
import org.junit.Assert;

class AbstractMultiClusterIT {
    static final JsonWriter JSON_WRITER = new JsonWriter();
    protected final String config;
    protected Cluster source;
    protected Cluster target;

    public AbstractMultiClusterIT(String config) {
        this.config = config;
    }

    @After
    public void cleanup() throws Exception {
        this.stopSourceCluster();
        this.stopTargetCluster();
    }

    protected void startSourceCluster() {
        this.source = new Cluster(new ClusterConfiguration(this.config, 2, 0));
        this.source.start("source");
    }

    protected void stopSourceCluster() throws Exception {
        if (this.source != null) {
            this.source.stop("source");
        }
    }

    protected void startTargetCluster() {
        this.target = new Cluster(new ClusterConfiguration(this.config, 2, 1000));
        this.target.start("target");
    }

    protected void stopTargetCluster() throws Exception {
        if (this.target != null) {
            this.target.stop("target");
        }
    }

    protected int getCacheSize(String cacheName, RestClient restClient) {
        RestCacheClient cache = restClient.cache(cacheName);
        return Integer.parseInt(((RestResponse)CompletionStages.join((CompletionStage)cache.size())).getBody());
    }

    protected void addSchema(RestClient client) {
        RestCacheClient cache = client.cache("___protobuf_metadata");
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)cache.put("schema.proto", "message Person {required string name = 1;}"));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        RestResponse errorResponse = (RestResponse)CompletionStages.join((CompletionStage)client.cache("___protobuf_metadata").get("schema.proto.errors"));
        Assert.assertEquals((long)404L, (long)errorResponse.getStatus());
    }

    protected void createCache(String cacheName, ConfigurationBuilder builder, RestClient client) {
        String cacheConfig = JSON_WRITER.toJSON((ConfigurationInfo)builder.build());
        StringRestEntityOkHttp body = new StringRestEntityOkHttp(MediaType.APPLICATION_JSON, cacheConfig);
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)client.cache(cacheName).createWithConfiguration((RestEntity)body, new CacheContainerAdmin.AdminFlag[0]));
        Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatus());
    }

    static class Cluster {
        final AbstractInfinispanServerDriver driver;
        final Map<Integer, RestClient> serverClients = new HashMap<Integer, RestClient>();

        Cluster(ClusterConfiguration simpleConfiguration) {
            Properties sysProps = System.getProperties();
            for (String prop : sysProps.stringPropertyNames()) {
                if (!prop.startsWith("org.infinispan.test.server.")) continue;
                simpleConfiguration.properties().put(prop, sysProps.getProperty(prop));
            }
            this.driver = ServerRunMode.DEFAULT.newDriver((InfinispanServerTestConfiguration)simpleConfiguration);
        }

        void start(String name) {
            this.driver.prepare(name);
            this.driver.start(name);
        }

        void stop(String name) throws Exception {
            this.driver.stop(name);
            for (RestClient client : this.serverClients.values()) {
                client.close();
            }
        }

        Set<String> getMembers() {
            String response = ((RestResponse)CompletionStages.join((CompletionStage)this.getClient().cacheManager("default").info())).getBody();
            Json jsonNode = Json.read((String)response);
            return jsonNode.at("cluster_members").asJsonList().stream().map(Json::asString).collect(Collectors.toSet());
        }

        RestClient getClient() {
            return this.getClient(0);
        }

        RestClient getClient(int server) {
            return this.serverClients.computeIfAbsent(server, k -> {
                InetSocketAddress serverSocket = this.driver.getServerSocket(server, 11222);
                return RestClient.forConfiguration((RestClientConfiguration)new RestClientConfigurationBuilder().addServer().host(serverSocket.getHostName()).port(serverSocket.getPort()).build());
            });
        }
    }

    protected static class ClusterConfiguration
    extends InfinispanServerTestConfiguration {
        public ClusterConfiguration(String configurationFile, int numServers, int portOffset) {
            super(configurationFile, numServers, ServerRunMode.EMBEDDED, new Properties(), null, null, false, false, false, Collections.emptyList(), null, portOffset);
        }
    }
}

