/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.server.functional.HotRodCacheContinuousQueries;
import org.infinispan.server.functional.HotRodCacheOperations;
import org.infinispan.server.functional.HotRodCacheQueries;
import org.infinispan.server.functional.HotRodCounterOperations;
import org.infinispan.server.functional.HotRodListenerWithDslFilter;
import org.infinispan.server.functional.HotRodMultiMapOperations;
import org.infinispan.server.functional.HotRodTransactionalCacheOperations;
import org.infinispan.server.functional.IgnoreCaches;
import org.infinispan.server.functional.JCacheOperations;
import org.infinispan.server.functional.MemcachedOperations;
import org.infinispan.server.functional.RestLoggingResource;
import org.infinispan.server.functional.RestMetricsResource;
import org.infinispan.server.functional.RestOperations;
import org.infinispan.server.functional.RestRouter;
import org.infinispan.server.functional.RestServerResource;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={RestMetricsResource.class, HotRodCacheOperations.class, RestOperations.class, RestRouter.class, RestServerResource.class, MemcachedOperations.class, HotRodCounterOperations.class, HotRodMultiMapOperations.class, HotRodTransactionalCacheOperations.class, HotRodCacheQueries.class, HotRodCacheContinuousQueries.class, HotRodListenerWithDslFilter.class, IgnoreCaches.class, JCacheOperations.class, RestLoggingResource.class})
public class ClusteredIT {
    @ClassRule
    public static final InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/ClusteredServerTest.xml").numServers(2)).build();

    static <K, V> RemoteCache<K, V> createQueryableCache(InfinispanServerTestMethodRule testMethodRule, boolean indexed) {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.marshaller((Marshaller)new ProtoStreamMarshaller());
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).stateTransfer().awaitInitialTransfer(true);
        if (indexed) {
            builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.User").addProperty("infinispan.query.lucene.max-boolean-clauses", "1025");
        }
        HotRodTestClientDriver hotRodTestClientDriver = testMethodRule.hotrod().withClientConfiguration(config);
        RemoteCacheManager remoteCacheManager = hotRodTestClientDriver.createRemoteCacheManager();
        RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        String schema = (String)Exceptions.unchecked(() -> Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)testMethodRule.getClass().getClassLoader()));
        metadataCache.putIfAbsent((Object)"sample_bank_account/bank.proto", (Object)schema);
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        Assert.assertNotNull((Object)metadataCache.get((Object)"sample_bank_account/bank.proto"));
        Exceptions.unchecked(() -> MarshallerRegistration.registerMarshallers((SerializationContext)MarshallerUtil.getSerializationContext((RemoteCacheManager)remoteCacheManager)));
        return ((HotRodTestClientDriver)hotRodTestClientDriver.withServerConfiguration(builder)).create();
    }
}

