/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.authorization;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractAuthorization {
    final Map<String, ConfigurationBuilder> hotRodBuilders = new HashMap<String, ConfigurationBuilder>();
    final Map<String, RestClientConfigurationBuilder> restBuilders = new HashMap<String, RestClientConfigurationBuilder>();
    final Map<String, String> bulkData;

    protected AbstractAuthorization() {
        this.addClientBuilders("admin", "strongPassword");
        this.addClientBuilders("writer", "somePassword");
        this.addClientBuilders("reader", "password");
        this.addClientBuilders("supervisor", "lessStrongPassword");
        this.bulkData = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            this.bulkData.put("k" + i, "v" + i);
        }
    }

    protected abstract InfinispanServerTestMethodRule getServerTest();

    protected void addClientBuilders(String username, String password) {
        ConfigurationBuilder hotRodBuilder = new ConfigurationBuilder();
        hotRodBuilder.security().authentication().saslMechanism("SCRAM-SHA-1").serverName("infinispan").realm("default").username(username).password(password);
        this.hotRodBuilders.put(username, hotRodBuilder);
        RestClientConfigurationBuilder restBuilder = new RestClientConfigurationBuilder();
        restBuilder.security().authentication().mechanism("AUTO").username(username).password(password);
        this.restBuilders.put(username, restBuilder);
    }

    @Test
    public void testHotRodAdminCanDoEverything() {
        RemoteCache adminCache = ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("admin")).withCacheMode(CacheMode.DIST_SYNC)).create();
        adminCache.put((Object)"k", (Object)"v");
        Assert.assertEquals((Object)"v", (Object)adminCache.get((Object)"k"));
        adminCache.putAll(this.bulkData);
        Assert.assertEquals((long)11L, (long)adminCache.size());
    }

    @Test
    public void testRestAdminCanDoEverything() {
        RestCacheClient adminCache = ((RestTestClientDriver)this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).withCacheMode(CacheMode.DIST_SYNC)).create().cache(this.getServerTest().getMethodName());
        Common.sync(adminCache.put("k", "v"));
        Assert.assertEquals((Object)"v", (Object)((RestResponse)Common.sync(adminCache.get("k"))).getBody());
    }

    @Test
    public void testHotRodNonAdminsMustNotCreateCache() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).withCacheMode(CacheMode.DIST_SYNC)).create());
        }
    }

    @Test
    public void testRestNonAdminsMustNotCreateCache() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Exceptions.expectException(RuntimeException.class, (String)"(?s).*403.*", () -> ((RestTestClientDriver)this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).withCacheMode(CacheMode.DIST_SYNC)).create());
        }
    }

    @Test
    public void testHotRodWriterCannotReadImplicit() {
        this.testHotRodWriterCannotRead(false);
    }

    @Test
    public void testHotRodWriterCannotReadExplicit() {
        this.testHotRodWriterCannotRead(true);
    }

    private void testHotRodWriterCannotRead(boolean explicitRoles) {
        this.hotRodCreateAuthzCache(explicitRoles);
        RemoteCache writerCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("writer")).get();
        writerCache.put((Object)"k1", (Object)"v1");
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> writerCache.get((Object)"k1"));
        for (String user : Arrays.asList("reader", "supervisor")) {
            RemoteCache userCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).get();
            Assert.assertEquals((Object)"v1", (Object)userCache.get((Object)"k1"));
        }
    }

    @Test
    public void testRestWriterCannotReadImplicit() {
        this.testRestWriterCannotRead(false);
    }

    @Test
    public void testRestWriterCannotReadExplicit() {
        this.testRestWriterCannotRead(true);
    }

    private void testRestWriterCannotRead(boolean explicitRoles) {
        this.restCreateAuthzCache(explicitRoles);
        RestCacheClient writerCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("writer")).get().cache(this.getServerTest().getMethodName());
        Common.sync(writerCache.put("k1", "v1"));
        Assert.assertEquals((long)403L, (long)((RestResponse)Common.sync(writerCache.get("k1"))).getStatus());
        for (String user : Arrays.asList("reader", "supervisor")) {
            RestCacheClient userCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(this.getServerTest().getMethodName());
            Assert.assertEquals((Object)"v1", (Object)((RestResponse)Common.sync(userCache.get("k1"))).getBody());
        }
    }

    @Test
    public void testHotRodReaderCannotWriteImplicit() {
        this.testHotRodReaderCannotWrite(false);
    }

    @Test
    public void testHotRodReaderCannotWriteExplicit() {
        this.testHotRodReaderCannotWrite(true);
    }

    private void testHotRodReaderCannotWrite(boolean explicitRoles) {
        this.hotRodCreateAuthzCache(explicitRoles);
        RemoteCache readerCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("reader")).get();
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.put((Object)"k1", (Object)"v1"));
        for (String user : Arrays.asList("writer", "supervisor")) {
            RemoteCache userCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).get();
            userCache.put((Object)user, (Object)user);
        }
    }

    @Test
    public void testRestReaderCannotWriteImplicit() {
        this.testRestReaderCannotWrite(false);
    }

    @Test
    public void testRestReaderCannotWriteExplicit() {
        this.testRestReaderCannotWrite(true);
    }

    private void testRestReaderCannotWrite(boolean explicitRoles) {
        this.restCreateAuthzCache(explicitRoles);
        RestCacheClient readerCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("reader")).get().cache(this.getServerTest().getMethodName());
        Assert.assertEquals((long)403L, (long)((RestResponse)Common.sync(readerCache.put("k1", "v1"))).getStatus());
        for (String user : Arrays.asList("writer", "supervisor")) {
            RestCacheClient userCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(this.getServerTest().getMethodName());
            userCache.put(user, user);
        }
    }

    @Test
    public void testHotRodBulkOperationsImplicit() {
        this.testHotRodBulkOperations(false);
    }

    @Test
    public void testHotRodBulkOperationsExplicit() {
        this.testHotRodBulkOperations(true);
    }

    private void testHotRodBulkOperations(boolean explicitRoles) {
        this.hotRodCreateAuthzCache(explicitRoles).putAll(this.bulkData);
        RemoteCache readerCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("reader")).get();
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.getAll(this.bulkData.keySet()));
        RemoteCache supervisorCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("supervisor")).get();
        supervisorCache.getAll(this.bulkData.keySet());
    }

    @Test
    public void testAnonymousHealthPredefinedCache() {
        RestClient client = this.getServerTest().rest().get();
        Assert.assertEquals((Object)"HEALTHY", (Object)((RestResponse)Common.sync(client.cacheManager("default").healthStatus())).getBody());
    }

    private RemoteCache<Object, Object> hotRodCreateAuthzCache(boolean explicitRoles) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        AuthorizationConfigurationBuilder authorizationConfigurationBuilder = builder.clustering().cacheMode(CacheMode.DIST_SYNC).security().authorization().enable();
        if (explicitRoles) {
            authorizationConfigurationBuilder.role("AdminRole").role("ReaderRole").role("WriterRole").role("SupervisorRole");
        }
        return ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("admin")).withServerConfiguration(builder)).create();
    }

    private RestClient restCreateAuthzCache(boolean explicitRoles) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        AuthorizationConfigurationBuilder authorizationConfigurationBuilder = builder.clustering().cacheMode(CacheMode.DIST_SYNC).security().authorization().enable();
        if (explicitRoles) {
            authorizationConfigurationBuilder.role("AdminRole").role("ReaderRole").role("WriterRole").role("SupervisorRole");
        }
        return ((RestTestClientDriver)this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).withServerConfiguration(builder)).create();
    }
}

