/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.security.Common;
import org.infinispan.server.security.SecurityRealmServerListener;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.LdapServerRule;
import org.infinispan.server.test.core.category.Security;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerRuleBuilder;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Security.class})
public class AuthenticationImplicitIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = ((InfinispanServerRuleBuilder)InfinispanServerRuleBuilder.config((String)"configuration/AuthenticationServerImplicitTest.xml").addListener((InfinispanServerListener)new SecurityRealmServerListener("alternate"))).build();
    @ClassRule
    public static LdapServerRule LDAP = new LdapServerRule(SERVERS);
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final String mechanism;
    private final String protocol;

    @Parameterized.Parameters(name="{1}({0})")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Object[] mech : Common.SASL_MECHS) {
            params.add(new Object[]{"Hot Rod", mech[0]});
        }
        for (Protocol protocol : Common.HTTP_PROTOCOLS) {
            for (Object[] mech : Common.HTTP_MECHS) {
                params.add(new Object[]{protocol.name(), mech[0]});
            }
        }
        return params;
    }

    public AuthenticationImplicitIT(String protocol, String mechanism) {
        this.protocol = protocol;
        this.mechanism = mechanism;
    }

    @Test
    public void testProtocol() {
        if ("Hot Rod".equals(this.protocol)) {
            this.testHotRod();
        } else {
            this.testRest(Protocol.valueOf((String)this.protocol));
        }
    }

    public void testHotRod() {
        block3: {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (!this.mechanism.isEmpty()) {
                builder.security().authentication().saslMechanism(this.mechanism).realm("default").username("all_user").password("all");
            }
            try {
                RemoteCache cache = ((HotRodTestClientDriver)this.SERVER_TEST.hotrod().withClientConfiguration(builder).withCacheMode(CacheMode.DIST_SYNC)).create();
                cache.put((Object)"k1", (Object)"v1");
                Assert.assertEquals((long)1L, (long)cache.size());
                Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
            }
            catch (HotRodClientException e) {
                if (this.mechanism.isEmpty() || "PLAIN".equals(this.mechanism)) break block3;
                throw e;
            }
        }
    }

    public void testRest(Protocol protocol) {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        if (!this.mechanism.isEmpty()) {
            builder.protocol(protocol).security().authentication().mechanism(this.mechanism).realm("default").username("all_user").password("all");
        }
        if (this.mechanism.isEmpty()) {
            Exceptions.expectException(SecurityException.class, () -> this.SERVER_TEST.rest().withClientConfiguration(builder).create());
        } else if ("BASIC".equals(this.mechanism)) {
            Exceptions.expectException(IllegalArgumentException.class, () -> this.SERVER_TEST.rest().withClientConfiguration(builder).create());
        } else {
            RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
            RestResponse response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).post("k1", "v1"));
            Assert.assertEquals((long)204L, (long)response.getStatus());
            Assert.assertEquals((Object)protocol, (Object)response.getProtocol());
            response = (RestResponse)Common.sync(client.cache(this.SERVER_TEST.getMethodName()).get("k1"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)protocol, (Object)response.getProtocol());
            Assert.assertEquals((Object)"v1", (Object)response.getBody());
        }
    }
}

