/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.cli;

import java.io.File;
import java.util.Properties;
import java.util.function.Consumer;
import org.aesh.command.shell.Shell;
import org.aesh.terminal.Connection;
import org.infinispan.cli.commands.CLI;
import org.infinispan.cli.impl.AeshDelegatingShell;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.server.functional.XSiteIT;
import org.infinispan.server.test.core.AeshTestConnection;
import org.infinispan.server.test.core.TestServer;
import org.infinispan.server.test.junit4.InfinispanXSiteServerRule;
import org.infinispan.server.test.junit4.InfinispanXSiteServerTestMethodRule;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class XSiteCliOperations {
    @ClassRule
    public static final InfinispanXSiteServerRule SERVERS = XSiteIT.SERVERS;
    @Rule
    public InfinispanXSiteServerTestMethodRule SERVER_TEST = new InfinispanXSiteServerTestMethodRule(SERVERS);
    private static File workingDir;
    private static Properties properties;

    @BeforeClass
    public static void setup() {
        workingDir = new File(CommonsTestingUtil.tmpDirectory(XSiteCliOperations.class));
        Util.recursiveFileRemove((File)workingDir);
        workingDir.mkdirs();
        properties = new Properties(System.getProperties());
        properties.put("cli.dir", workingDir.getAbsolutePath());
    }

    @AfterClass
    public static void teardown() {
        Util.recursiveFileRemove((File)workingDir);
    }

    @Test
    public void testSiteView() {
        this.doWithTerminal(terminal -> {
            this.connect((AeshTestConnection)terminal, "LON");
            terminal.readln("site name");
            terminal.assertContains("LON");
            terminal.clear();
            terminal.readln("site view");
            terminal.assertContains("LON");
            terminal.assertContains("NYC");
            terminal.clear();
            this.disconnect((AeshTestConnection)terminal);
            this.connect((AeshTestConnection)terminal, "NYC");
            terminal.readln("site name");
            terminal.assertContains("NYC");
            terminal.clear();
            terminal.readln("site view");
            terminal.assertContains("LON");
            terminal.assertContains("NYC");
            terminal.clear();
        });
    }

    private void connect(AeshTestConnection terminal, String site) {
        terminal.readln("connect " + this.hostAndPort(site));
        terminal.assertContains("//containers/default]>");
        terminal.clear();
    }

    private void disconnect(AeshTestConnection terminal) {
        terminal.readln("disconnect");
        terminal.clear();
    }

    private String hostAndPort(String site) {
        for (TestServer server : SERVERS.getTestServers()) {
            if (!site.equals(server.getSiteName())) continue;
            String host = server.getDriver().getServerAddress(0).getHostAddress();
            int port = server.getDriver().getServerSocket(0, 11222).getPort();
            return host + ":" + port;
        }
        throw new IllegalStateException("Site " + site + " not found.");
    }

    private void doWithTerminal(Consumer<AeshTestConnection> consumer) {
        try (AeshTestConnection terminal = new AeshTestConnection();){
            CLI.main((Shell)new AeshDelegatingShell((Connection)terminal), (String[])new String[0], (Properties)properties);
            consumer.accept(terminal);
        }
    }
}

