/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractAuthorization {
    final Map<String, ConfigurationBuilder> hotRodBuilders = new HashMap<String, ConfigurationBuilder>();
    final Map<String, RestClientConfigurationBuilder> restBuilders = new HashMap<String, RestClientConfigurationBuilder>();
    final Map<String, String> bulkData;

    protected AbstractAuthorization() {
        this.addClientBuilders("admin", "strongPassword");
        this.addClientBuilders("writer", "somePassword");
        this.addClientBuilders("reader", "password");
        this.addClientBuilders("supervisor", "lessStrongPassword");
        this.bulkData = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            this.bulkData.put("k" + i, "v" + i);
        }
    }

    protected abstract InfinispanServerTestMethodRule getServerTest();

    protected void addClientBuilders(String username, String password) {
        ConfigurationBuilder hotRodBuilder = new ConfigurationBuilder();
        hotRodBuilder.security().authentication().saslMechanism("SCRAM-SHA-1").serverName("infinispan").realm("default").username(username).password(password);
        this.hotRodBuilders.put(username, hotRodBuilder);
        RestClientConfigurationBuilder restBuilder = new RestClientConfigurationBuilder();
        restBuilder.security().authentication().mechanism("AUTO").username(username).password(password);
        this.restBuilders.put(username, restBuilder);
    }

    @Test
    public void testHotRodAdminCanDoEverything() {
        RemoteCache adminCache = ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("admin")).withCacheMode(CacheMode.DIST_SYNC)).create();
        adminCache.put((Object)"k", (Object)"v");
        Assert.assertEquals((Object)"v", (Object)adminCache.get((Object)"k"));
        adminCache.putAll(this.bulkData);
        Assert.assertEquals((long)11L, (long)adminCache.size());
    }

    @Test
    public void testRestAdminCanDoEverything() {
        RestCacheClient adminCache = ((RestTestClientDriver)this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).withCacheMode(CacheMode.DIST_SYNC)).create().cache(this.getServerTest().getMethodName());
        Common.sync(adminCache.put("k", "v"));
        Assert.assertEquals((Object)"v", (Object)((RestResponse)Common.sync(adminCache.get("k"))).getBody());
    }

    @Test
    public void testHotRodNonAdminsMustNotCreateCache() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).withCacheMode(CacheMode.DIST_SYNC)).create());
        }
    }

    @Test
    public void testRestNonAdminsMustNotCreateCache() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Exceptions.expectException(SecurityException.class, (String)"(?s).*403.*", () -> ((RestTestClientDriver)this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).withCacheMode(CacheMode.DIST_SYNC)).create());
        }
    }

    @Test
    public void testHotRodWriterCannotReadImplicit() {
        this.testHotRodWriterCannotRead(false);
    }

    @Test
    public void testHotRodWriterCannotReadExplicit() {
        this.testHotRodWriterCannotRead(true);
    }

    private void testHotRodWriterCannotRead(boolean explicitRoles) {
        this.hotRodCreateAuthzCache(explicitRoles);
        RemoteCache writerCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("writer")).get();
        writerCache.put((Object)"k1", (Object)"v1");
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> writerCache.get((Object)"k1"));
        for (String user : Arrays.asList("reader", "supervisor")) {
            RemoteCache userCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).get();
            Assert.assertEquals((Object)"v1", (Object)userCache.get((Object)"k1"));
        }
    }

    @Test
    public void testRestWriterCannotReadImplicit() {
        this.testRestWriterCannotRead(false);
    }

    @Test
    public void testRestWriterCannotReadExplicit() {
        this.testRestWriterCannotRead(true);
    }

    private void testRestWriterCannotRead(boolean explicitRoles) {
        this.restCreateAuthzCache(explicitRoles);
        RestCacheClient writerCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("writer")).get().cache(this.getServerTest().getMethodName());
        Common.sync(writerCache.put("k1", "v1"));
        Common.assertStatus(403, writerCache.get("k1"));
        for (String user : Arrays.asList("reader", "supervisor")) {
            RestCacheClient userCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(this.getServerTest().getMethodName());
            Assert.assertEquals((Object)"v1", (Object)((RestResponse)Common.sync(userCache.get("k1"))).getBody());
        }
    }

    @Test
    public void testHotRodReaderCannotWriteImplicit() {
        this.testHotRodReaderCannotWrite(false);
    }

    @Test
    public void testHotRodReaderCannotWriteExplicit() {
        this.testHotRodReaderCannotWrite(true);
    }

    private void testHotRodReaderCannotWrite(boolean explicitRoles) {
        this.hotRodCreateAuthzCache(explicitRoles);
        RemoteCache readerCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("reader")).get();
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.put((Object)"k1", (Object)"v1"));
        for (String user : Arrays.asList("writer", "supervisor")) {
            RemoteCache userCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).get();
            userCache.put((Object)user, (Object)user);
        }
    }

    @Test
    public void testRestReaderCannotWriteImplicit() {
        this.testRestReaderCannotWrite(false);
    }

    @Test
    public void testRestReaderCannotWriteExplicit() {
        this.testRestReaderCannotWrite(true);
    }

    private void testRestReaderCannotWrite(boolean explicitRoles) {
        this.restCreateAuthzCache(explicitRoles);
        RestCacheClient readerCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("reader")).get().cache(this.getServerTest().getMethodName());
        Common.assertStatus(403, readerCache.put("k1", "v1"));
        for (String user : Arrays.asList("writer", "supervisor")) {
            RestCacheClient userCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(this.getServerTest().getMethodName());
            userCache.put(user, user);
        }
    }

    @Test
    public void testHotRodBulkOperationsImplicit() {
        this.testHotRodBulkOperations(false);
    }

    @Test
    public void testHotRodBulkOperationsExplicit() {
        this.testHotRodBulkOperations(true);
    }

    private void testHotRodBulkOperations(boolean explicitRoles) {
        this.hotRodCreateAuthzCache(explicitRoles).putAll(this.bulkData);
        RemoteCache readerCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("reader")).get();
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.getAll(this.bulkData.keySet()));
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> new ArrayList(readerCache.keySet()));
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> new ArrayList(readerCache.values()));
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> new ArrayList(readerCache.entrySet()));
        RemoteCache supervisorCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("supervisor")).get();
        supervisorCache.getAll(this.bulkData.keySet());
        Assert.assertFalse((boolean)new HashSet(supervisorCache.keySet()).isEmpty());
        Assert.assertFalse((boolean)new HashSet(supervisorCache.values()).isEmpty());
        Assert.assertFalse((boolean)new HashSet(supervisorCache.entrySet()).isEmpty());
    }

    @Test
    public void testAnonymousHealthPredefinedCache() {
        RestClient client = this.getServerTest().rest().get();
        Assert.assertEquals((Object)"HEALTHY", (Object)((RestResponse)Common.sync(client.cacheManager("default").healthStatus())).getBody());
    }

    @Test
    public void testRestNonAdminsMustNotShutdownServer() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().server().stop());
        }
    }

    @Test
    public void testRestNonAdminsMustNotShutdownCluster() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cluster().stop());
        }
    }

    @Test
    public void testRestNonAdminsMustNotModifyCacheIgnores() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().server().ignoreCache("default", "predefined"));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().server().unIgnoreCache("default", "predefined"));
        }
    }

    @Test
    public void testRestAdminsShouldBeAbleToModifyLoggers() {
        Common.assertStatus(204, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).get().server().logging().setLogger("org.infinispan.TEST_LOGGER", "ERROR", new String[]{"STDOUT"}));
        Common.assertStatus(204, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).get().server().logging().removeLogger("org.infinispan.TEST_LOGGER"));
    }

    @Test
    public void testRestNonAdminsMustNotModifyLoggers() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().server().logging().setLogger("org.infinispan.TEST_LOGGER", "ERROR", new String[]{"STDOUT"}));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().server().logging().removeLogger("org.infinispan.TEST_LOGGER"));
        }
    }

    @Test
    public void testRestAdminsShoudleBeAbleToAdminServer() {
        RestClientConfigurationBuilder adminConfig = this.restBuilders.get("admin");
        Common.assertStatus(204, this.getServerTest().rest().withClientConfiguration(adminConfig).get().server().connectorStop("endpoint-alternate-1"));
        Common.assertStatus(204, this.getServerTest().rest().withClientConfiguration(adminConfig).get().server().connectorStart("endpoint-alternate-1"));
        Common.assertStatus(204, this.getServerTest().rest().withClientConfiguration(adminConfig).get().server().connectorIpFilterSet("endpoint-alternate-1", Collections.emptyList()));
        Common.assertStatus(204, this.getServerTest().rest().withClientConfiguration(adminConfig).get().server().connectorIpFiltersClear("endpoint-alternate-1"));
        Common.assertStatus(200, this.getServerTest().rest().withClientConfiguration(adminConfig).get().server().memory());
        Common.assertStatus(200, this.getServerTest().rest().withClientConfiguration(adminConfig).get().server().env());
        Common.assertStatus(200, this.getServerTest().rest().withClientConfiguration(adminConfig).get().server().configuration());
    }

    @Test
    public void testRestNonAdminsMustNotAdminServer() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            RestClientConfigurationBuilder userConfig = this.restBuilders.get(user);
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(userConfig).get().server().report());
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(userConfig).get().server().connectorStop("endpoint-default"));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(userConfig).get().server().connectorStart("endpoint-default"));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(userConfig).get().server().connectorIpFilterSet("endpoint-default", Collections.emptyList()));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(userConfig).get().server().connectorIpFiltersClear("endpoint-default"));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(userConfig).get().server().memory());
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(userConfig).get().server().env());
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(userConfig).get().server().configuration());
        }
    }

    @Test
    public void testAdminsAccessToPerformXSiteOps() {
        this.assertXSiteOps("admin", 200, 204);
    }

    @Test
    public void testRestNonAdminsMustNotAccessPerformXSiteOps() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            this.assertXSiteOps(user, 403, 403);
        }
    }

    private void assertXSiteOps(String user, int status, int noContentStatus) {
        RestClientConfigurationBuilder userConfig = this.restBuilders.get(user);
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cache("xsite").takeSiteOffline("NYC"));
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cache("xsite").bringSiteOnline("NYC"));
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cache("xsite").cancelPushState("NYC"));
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cache("xsite").cancelReceiveState("NYC"));
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cache("xsite").clearPushStateStatus());
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cache("xsite").pushSiteState("NYC"));
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cache("xsite").pushStateStatus());
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cache("xsite").xsiteBackups());
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cache("xsite").backupStatus("NYC"));
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cache("xsite").getXSiteTakeOfflineConfig("NYC"));
        Common.assertStatus(noContentStatus, this.getServerTest().rest().withClientConfiguration(userConfig).get().cache("xsite").updateXSiteTakeOfflineConfig("NYC", 10, 1000L));
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cacheManager("default").bringBackupOnline("NYC"));
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cacheManager("default").takeOffline("NYC"));
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(userConfig).get().cacheManager("default").backupStatuses());
    }

    @Test
    public void testRestNonAdminsMustNotPerformSearchActions() {
        String schema = (String)Exceptions.unchecked(() -> Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader()));
        Common.assertStatus(200, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).get().schemas().put("bank.proto", schema));
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.indexing().enable().addIndexedEntity("sample_bank_account.User").statistics().enable();
        RestClient restClient = ((RestTestClientDriver)this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).withServerConfiguration(builder)).create();
        String indexedCache = this.getServerTest().getMethodName();
        RestCacheClient cache = restClient.cache(indexedCache);
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            this.searchActions(user, indexedCache, 403, 403);
        }
        this.searchActions("admin", indexedCache, 200, 204);
    }

    private void searchActions(String user, String indexedCache, int status, int noContentStatus) {
        Common.assertStatus(status, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(indexedCache).clearSearchStats());
        Common.assertStatus(noContentStatus, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(indexedCache).reindex());
        Common.assertStatus(noContentStatus, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(indexedCache).clearIndex());
    }

    @Test
    @Ignore
    public void testRestAdminsMustAccessBackupsAndRestores() {
        Common.assertStatus(202, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).get().cluster().createBackup("backup"));
        Common.awaitStatus(() -> this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).get().cluster().getBackup("backup", true), 202, 200);
        Common.assertStatus(200, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).get().cluster().getBackupNames());
        Common.assertStatus(204, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).get().cluster().deleteBackup("backup"));
        Common.assertStatus(202, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).get().cluster().restore("restore", "somewhere"));
        Common.assertStatus(200, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).get().cluster().getRestoreNames());
        Common.assertStatus(200, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).get().cluster().getRestore("restore"));
        Common.assertStatus(200, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).get().cluster().deleteRestore("restore"));
    }

    @Test
    public void testRestNonAdminsMustNotAccessBackupsAndRestores() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cluster().createBackup("backup"));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cluster().getBackup("backup", true));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cluster().getBackupNames());
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cluster().deleteBackup("backup"));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cluster().restore("restore", "somewhere"));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cluster().getRestoreNames());
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cluster().getRestore("restore"));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cluster().deleteRestore("restore"));
        }
    }

    private void backupAndRestore(String user, int status, int noContentStatus, int acceptedStatus) {
    }

    private RemoteCache<Object, Object> hotRodCreateAuthzCache(boolean explicitRoles) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        AuthorizationConfigurationBuilder authorizationConfigurationBuilder = builder.clustering().cacheMode(CacheMode.DIST_SYNC).security().authorization().enable();
        if (explicitRoles) {
            authorizationConfigurationBuilder.role("AdminRole").role("ReaderRole").role("WriterRole").role("SupervisorRole");
        }
        return ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get("admin")).withServerConfiguration(builder)).create();
    }

    private RestClient restCreateAuthzCache(boolean explicitRoles) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        AuthorizationConfigurationBuilder authorizationConfigurationBuilder = builder.clustering().cacheMode(CacheMode.DIST_SYNC).security().authorization().enable();
        if (explicitRoles) {
            authorizationConfigurationBuilder.role("AdminRole").role("ReaderRole").role("WriterRole").role("SupervisorRole");
        }
        return ((RestTestClientDriver)this.getServerTest().rest().withClientConfiguration(this.restBuilders.get("admin")).withServerConfiguration(builder)).create();
    }
}

