/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.concurrent.CompletionStage;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.server.functional.AbstractMultiClusterIT;
import org.infinispan.util.concurrent.CompletionStages;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RollingUpgradeIT
extends AbstractMultiClusterIT {
    protected static final String CACHE_NAME = "rolling";
    private static final int ENTRIES = 50;

    public RollingUpgradeIT() {
        super("configuration/ClusteredServerTest.xml");
    }

    @Before
    public void before() {
        this.startSourceCluster();
        this.startTargetCluster();
        Assert.assertEquals((long)2L, (long)this.source.getMembers().size());
        Assert.assertEquals((long)2L, (long)this.target.getMembers().size());
        Assert.assertNotSame(this.source.getMembers(), this.target.getMembers());
    }

    @After
    public void after() throws Exception {
        this.source.stop("source");
        this.target.stop("target");
    }

    @Test
    public void testRollingUpgrade() throws Exception {
        RestClient restClientSource = this.source.getClient();
        RestClient restClientTarget = this.target.getClient();
        this.createSourceClusterCache();
        this.createTargetClusterCache();
        this.addSchema(restClientSource);
        this.addSchema(restClientTarget);
        this.populateCluster(restClientSource);
        Assert.assertEquals((Object)"name-20", (Object)this.getPersonName("20", restClientTarget));
        this.doRollingUpgrade(restClientTarget);
        this.disconnectSource(restClientTarget);
        this.stopSourceCluster();
        for (int i = 0; i < this.target.getMembers().size(); ++i) {
            RestClient restClient = this.target.getClient(i);
            Assert.assertEquals((long)50L, (long)this.getCacheSize(CACHE_NAME, restClient));
            Assert.assertEquals((Object)"name-35", (Object)this.getPersonName("35", restClient));
        }
    }

    protected void disconnectSource(RestClient client) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)client.cache(CACHE_NAME).disconnectSource());
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    protected void doRollingUpgrade(RestClient client) {
        RestResponse response = (RestResponse)CompletionStages.join((CompletionStage)client.cache(CACHE_NAME).synchronizeData());
        Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatus());
    }

    private String getPersonName(String id, RestClient client) {
        RestResponse resp = (RestResponse)CompletionStages.join((CompletionStage)client.cache(CACHE_NAME).get(id));
        String body = resp.getBody();
        Assert.assertEquals((String)body, (long)200L, (long)resp.getStatus());
        return Json.read((String)body).at("name").asString();
    }

    public void populateCluster(RestClient client) {
        RestCacheClient cache = client.cache(CACHE_NAME);
        for (int i = 0; i < 50; ++i) {
            String person = this.createPerson("name-" + i);
            CompletionStages.join((CompletionStage)cache.put(String.valueOf(i), person));
        }
        Assert.assertEquals((long)50L, (long)this.getCacheSize(CACHE_NAME, client));
    }

    private String createPerson(String name) {
        return String.format("{\"_type\":\"Person\",\"name\":\"%s\"}", name);
    }

    private void createTargetClusterCache() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)builder.clustering().cacheMode(CacheMode.DIST_SYNC).persistence().addStore(RemoteStoreConfigurationBuilder.class)).remoteCacheName(CACHE_NAME).hotRodWrapping(true).protocolVersion(ProtocolVersion.PROTOCOL_VERSION_25).shared(true)).addServer().host(this.source.driver.getServerAddress(0).getHostAddress()).port(11222);
        this.createCache(CACHE_NAME, builder, this.target.getClient());
    }

    private void createSourceClusterCache() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        this.createCache(CACHE_NAME, builder, this.source.getClient());
    }
}

