/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.authorization;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestCacheManagerClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestClusterClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.functional.HotRodCacheQueries;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.Common;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.infinispan.server.test.junit4.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractAuthorization {
    public static final String BANK_PROTO = "bank.proto";
    final Map<TestUser, ConfigurationBuilder> hotRodBuilders = new HashMap<TestUser, ConfigurationBuilder>();
    final Map<TestUser, RestClientConfigurationBuilder> restBuilders = new HashMap<TestUser, RestClientConfigurationBuilder>();
    final Map<String, String> bulkData;

    protected AbstractAuthorization() {
        Stream.of(TestUser.values()).forEach(this::addClientBuilders);
        this.bulkData = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            this.bulkData.put("k" + i, "v" + i);
        }
    }

    protected abstract InfinispanServerRule getServers();

    protected abstract InfinispanServerTestMethodRule getServerTest();

    protected void addClientBuilders(TestUser user) {
        ConfigurationBuilder hotRodBuilder = new ConfigurationBuilder();
        hotRodBuilder.security().authentication().saslMechanism("SCRAM-SHA-1").serverName("infinispan").realm("default").username(user.getUser()).password(user.getPassword());
        this.hotRodBuilders.put(user, hotRodBuilder);
        RestClientConfigurationBuilder restBuilder = new RestClientConfigurationBuilder();
        restBuilder.security().authentication().mechanism("AUTO").username(user.getUser()).password(user.getPassword());
        this.restBuilders.put(user, restBuilder);
    }

    @Test
    public void testHotRodAdminAndDeployerCanDoEverything() {
        for (TestUser user : EnumSet.of(TestUser.ADMIN, TestUser.DEPLOYER)) {
            RemoteCache cache = ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).withCacheMode(CacheMode.DIST_SYNC)).create();
            cache.put((Object)"k", (Object)"v");
            Assert.assertEquals((Object)"v", (Object)cache.get((Object)"k"));
            cache.putAll(this.bulkData);
            Assert.assertEquals((long)11L, (long)cache.size());
            cache.getRemoteCacheManager().administration().removeCache(cache.getName());
        }
    }

    @Test
    public void testRestAdminCanDoEverything() {
        RestCacheClient adminCache = ((RestTestClientDriver)this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(TestUser.ADMIN)).withCacheMode(CacheMode.DIST_SYNC)).create().cache(this.getServerTest().getMethodName());
        Common.sync(adminCache.put("k", "v"));
        Assert.assertEquals((Object)"v", (Object)((RestResponse)Common.sync(adminCache.get("k"))).getBody());
    }

    @Test
    public void testHotRodNonAdminsMustNotCreateCache() {
        for (TestUser user : EnumSet.of(TestUser.APPLICATION, TestUser.OBSERVER)) {
            Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).withCacheMode(CacheMode.DIST_SYNC)).create());
        }
    }

    @Test
    public void testRestNonAdminsMustNotCreateCache() {
        for (TestUser user : EnumSet.of(TestUser.APPLICATION, TestUser.OBSERVER)) {
            Exceptions.expectException(SecurityException.class, (String)"(?s).*403.*", () -> ((RestTestClientDriver)this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).withCacheMode(CacheMode.DIST_SYNC)).create());
        }
    }

    @Test
    public void testHotRodWriterCannotReadImplicit() {
        this.testHotRodWriterCannotRead(new String[0]);
    }

    @Test
    public void testHotRodWriterCannotReadExplicit() {
        this.testHotRodWriterCannotRead("admin", "observer", "deployer", "application", "writer", "reader");
    }

    private void testHotRodWriterCannotRead(String ... explicitRoles) {
        this.hotRodCreateAuthzCache(explicitRoles);
        RemoteCache writerCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(TestUser.WRITER)).get();
        writerCache.put((Object)"k1", (Object)"v1");
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> writerCache.get((Object)"k1"));
        for (TestUser user : EnumSet.complementOf(EnumSet.of(TestUser.WRITER))) {
            RemoteCache userCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).get();
            Assert.assertEquals((Object)"v1", (Object)userCache.get((Object)"k1"));
        }
    }

    @Test
    public void testAdminCanRemoveCacheWithoutRole() {
        RemoteCache adminCache = this.hotRodCreateAuthzCache("application");
        RemoteCache appCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(TestUser.APPLICATION)).get();
        appCache.put((Object)"k1", (Object)"v1");
        adminCache.getRemoteCacheManager().administration().removeCache(adminCache.getName());
    }

    @Test
    public void testRestWriterCannotReadImplicit() {
        this.testRestWriterCannotRead(new String[0]);
    }

    @Test
    public void testRestWriterCannotReadExplicit() {
        this.testRestWriterCannotRead("admin", "observer", "deployer", "application", "writer", "reader");
    }

    private void testRestWriterCannotRead(String ... explicitRoles) {
        this.restCreateAuthzCache(explicitRoles);
        RestCacheClient writerCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(TestUser.WRITER)).get().cache(this.getServerTest().getMethodName());
        Common.sync(writerCache.put("k1", "v1"));
        Common.assertStatus(403, writerCache.get("k1"));
        for (TestUser user : EnumSet.of(TestUser.OBSERVER, TestUser.DEPLOYER)) {
            RestCacheClient userCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(this.getServerTest().getMethodName());
            Assert.assertEquals((Object)"v1", (Object)((RestResponse)Common.sync(userCache.get("k1"))).getBody());
        }
    }

    @Test
    public void testHotRodReaderCannotWriteImplicit() {
        this.testHotRodObserverCannotWrite(new String[0]);
    }

    @Test
    public void testHotRodReaderCannotWriteExplicit() {
        this.testHotRodObserverCannotWrite(new String[0]);
    }

    private void testHotRodObserverCannotWrite(String ... explicitRoles) {
        this.hotRodCreateAuthzCache(explicitRoles);
        RemoteCache readerCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(TestUser.OBSERVER)).get();
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.put((Object)"k1", (Object)"v1"));
        for (TestUser user : EnumSet.of(TestUser.DEPLOYER, TestUser.APPLICATION, TestUser.WRITER)) {
            RemoteCache userCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).get();
            userCache.put((Object)user.name(), (Object)user.name());
        }
    }

    @Test
    public void testRestReaderCannotWriteImplicit() {
        this.testRestReaderCannotWrite(new String[0]);
    }

    @Test
    public void testRestReaderCannotWriteExplicit() {
        this.testRestReaderCannotWrite("admin", "observer", "deployer", "application", "writer", "reader");
    }

    private void testRestReaderCannotWrite(String ... explicitRoles) {
        this.restCreateAuthzCache(explicitRoles);
        RestCacheClient readerCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(TestUser.OBSERVER)).get().cache(this.getServerTest().getMethodName());
        Common.assertStatus(403, readerCache.put("k1", "v1"));
        for (TestUser user : EnumSet.of(TestUser.APPLICATION, TestUser.DEPLOYER)) {
            RestCacheClient userCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(this.getServerTest().getMethodName());
            Common.assertStatus(204, userCache.put(user.name(), user.name()));
        }
    }

    @Test
    public void testHotRodBulkOperationsImplicit() {
        this.testHotRodBulkOperations(new String[0]);
    }

    @Test
    public void testHotRodBulkOperationsExplicit() {
        this.testHotRodBulkOperations("admin", "observer", "deployer", "application", "writer", "reader");
    }

    private void testHotRodBulkOperations(String ... explicitRoles) {
        this.hotRodCreateAuthzCache(explicitRoles).putAll(this.bulkData);
        RemoteCache readerCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(TestUser.READER)).get();
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.getAll(this.bulkData.keySet()));
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> new ArrayList(readerCache.keySet()));
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> new ArrayList(readerCache.values()));
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> new ArrayList(readerCache.entrySet()));
        RemoteCache supervisorCache = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(TestUser.DEPLOYER)).get();
        supervisorCache.getAll(this.bulkData.keySet());
        Assert.assertFalse((boolean)new HashSet(supervisorCache.keySet()).isEmpty());
        Assert.assertFalse((boolean)new HashSet(supervisorCache.values()).isEmpty());
        Assert.assertFalse((boolean)new HashSet(supervisorCache.entrySet()).isEmpty());
    }

    @Test
    public void testAdminAndDeployerCanManageSchema() {
        String schema = (String)Exceptions.unchecked(() -> Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader()));
        for (TestUser user : EnumSet.of(TestUser.ADMIN, TestUser.DEPLOYER)) {
            RemoteCacheManager remoteCacheManager = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).createRemoteCacheManager();
            RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
            metadataCache.put((Object)BANK_PROTO, (Object)schema);
            metadataCache.remove((Object)BANK_PROTO);
        }
    }

    @Test
    public void testNonCreatorsSchema() {
        String schema = (String)Exceptions.unchecked(() -> Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader()));
        for (TestUser user : EnumSet.of(TestUser.APPLICATION, TestUser.OBSERVER, TestUser.WRITER)) {
            RemoteCacheManager remoteCacheManager = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(user)).createRemoteCacheManager();
            RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
            Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> metadataCache.put((Object)BANK_PROTO, (Object)schema));
        }
    }

    @Test
    public void testBulkReadUsersCanQuery() {
        RemoteCache userCache;
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.prepareIndexedCache();
        for (TestUser user : EnumSet.of(TestUser.ADMIN, TestUser.DEPLOYER, TestUser.APPLICATION, TestUser.OBSERVER)) {
            userCache = ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.clientConfigurationWithProtostreamMarshaller(user)).withServerConfiguration(builder)).get();
            User fromCache = (User)userCache.get((Object)1);
            HotRodCacheQueries.assertUser1(fromCache);
            QueryFactory qf = Search.getQueryFactory((RemoteCache)userCache);
            Query query = qf.create("FROM sample_bank_account.User WHERE name = 'Tom'");
            List list = query.execute().list();
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
            HotRodCacheQueries.assertUser1((User)list.get(0));
        }
        for (TestUser user : EnumSet.of(TestUser.ADMIN, TestUser.DEPLOYER, TestUser.APPLICATION, TestUser.OBSERVER)) {
            userCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(this.getServerTest().getMethodName());
            Common.assertStatus(200, userCache.query("FROM sample_bank_account.User WHERE name = 'Tom'"));
            Common.assertStatus(200, userCache.searchStats());
            Common.assertStatus(200, userCache.indexStats());
            Common.assertStatus(200, userCache.queryStats());
        }
    }

    @Test
    public void testNonBulkReadUsersCannotQuery() {
        RemoteCache userCache;
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.prepareIndexedCache();
        for (TestUser user : EnumSet.of(TestUser.READER, TestUser.WRITER)) {
            userCache = ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.clientConfigurationWithProtostreamMarshaller(user)).withServerConfiguration(builder)).get();
            QueryFactory qf = Search.getQueryFactory((RemoteCache)userCache);
            Query query = qf.create("FROM sample_bank_account.User WHERE name = 'Tom'");
            Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> query.execute().list());
        }
        for (TestUser user : EnumSet.of(TestUser.READER, TestUser.WRITER)) {
            userCache = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cache(this.getServerTest().getMethodName());
            Common.assertStatus(403, userCache.query("FROM sample_bank_account.User WHERE name = 'Tom'"));
            Common.assertStatus(200, userCache.searchStats());
            Common.assertStatus(200, userCache.indexStats());
            Common.assertStatus(200, userCache.queryStats());
        }
    }

    private org.infinispan.configuration.cache.ConfigurationBuilder prepareIndexedCache() {
        String schema = (String)Exceptions.unchecked(() -> Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader()));
        RemoteCacheManager remoteCacheManager = this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(TestUser.ADMIN)).createRemoteCacheManager();
        RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)BANK_PROTO, (Object)schema);
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).stateTransfer().awaitInitialTransfer(true).security().authorization().enable().indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.User");
        RemoteCache adminCache = ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.clientConfigurationWithProtostreamMarshaller(TestUser.ADMIN)).withServerConfiguration(builder)).create();
        adminCache.put((Object)1, (Object)HotRodCacheQueries.createUser1());
        adminCache.put((Object)2, (Object)HotRodCacheQueries.createUser2());
        return builder;
    }

    private ConfigurationBuilder clientConfigurationWithProtostreamMarshaller(TestUser user) {
        ConfigurationBuilder client = new ConfigurationBuilder().read(this.hotRodBuilders.get(user).build());
        ProtoStreamMarshaller marshaller = new ProtoStreamMarshaller();
        client.marshaller((Marshaller)marshaller);
        Exceptions.unchecked(() -> MarshallerRegistration.registerMarshallers((SerializationContext)marshaller.getSerializationContext()));
        return client;
    }

    @Test
    public void testAnonymousHealthPredefinedCache() {
        RestClient client = this.getServerTest().rest().get();
        Assert.assertEquals((Object)"HEALTHY", (Object)((RestResponse)Common.sync(client.cacheManager("default").healthStatus())).getBody());
    }

    @Test
    public void testRestNonAdminsMustNotShutdownServer() {
        for (TestUser user : TestUser.NON_ADMINS) {
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().server().stop());
        }
    }

    @Test
    public void testRestNonAdminsMustNotShutdownCluster() {
        for (TestUser user : TestUser.NON_ADMINS) {
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cluster().stop());
        }
    }

    @Test
    public void testRestNonAdminsMustNotModifyCacheIgnores() {
        for (TestUser user : TestUser.NON_ADMINS) {
            RestClient client = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get();
            Common.assertStatus(403, client.server().ignoreCache("default", "predefined"));
            Common.assertStatus(403, client.server().unIgnoreCache("default", "predefined"));
        }
    }

    @Test
    public void testRestAdminsShouldBeAbleToModifyLoggers() {
        RestClient client = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(TestUser.ADMIN)).get();
        Common.assertStatus(204, client.server().logging().setLogger("org.infinispan.TEST_LOGGER", "ERROR", new String[]{"STDOUT"}));
        Common.assertStatus(204, client.server().logging().removeLogger("org.infinispan.TEST_LOGGER"));
    }

    @Test
    public void testRestNonAdminsMustNotModifyLoggers() {
        for (TestUser user : TestUser.NON_ADMINS) {
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().server().logging().setLogger("org.infinispan.TEST_LOGGER", "ERROR", new String[]{"STDOUT"}));
            Common.assertStatus(403, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().server().logging().removeLogger("org.infinispan.TEST_LOGGER"));
        }
    }

    @Test
    public void testRestAdminsShoudleBeAbleToAdminServer() {
        RestClientConfigurationBuilder adminConfig = this.restBuilders.get(TestUser.ADMIN);
        RestClient client = this.getServerTest().rest().withClientConfiguration(adminConfig).get();
        Common.assertStatus(204, client.server().connectorStop("endpoint-alternate-1"));
        Common.assertStatus(204, client.server().connectorStart("endpoint-alternate-1"));
        Common.assertStatus(204, client.server().connectorIpFilterSet("endpoint-alternate-1", Collections.emptyList()));
        Common.assertStatus(204, client.server().connectorIpFiltersClear("endpoint-alternate-1"));
        Common.assertStatus(200, client.server().memory());
        Common.assertStatus(200, client.server().env());
        Common.assertStatus(200, client.server().configuration());
    }

    @Test
    public void testRestNonAdminsMustNotAdminServer() {
        for (TestUser user : TestUser.NON_ADMINS) {
            RestClientConfigurationBuilder userConfig = this.restBuilders.get(user);
            RestClient client = this.getServerTest().rest().withClientConfiguration(userConfig).get();
            Common.assertStatus(403, client.server().report());
            Common.assertStatus(403, client.server().connectorStop("endpoint-default"));
            Common.assertStatus(403, client.server().connectorStart("endpoint-default"));
            Common.assertStatus(403, client.server().connectorIpFilterSet("endpoint-default", Collections.emptyList()));
            Common.assertStatus(403, client.server().connectorIpFiltersClear("endpoint-default"));
            Common.assertStatus(403, client.server().memory());
            Common.assertStatus(403, client.server().env());
            Common.assertStatus(403, client.server().configuration());
        }
    }

    @Test
    public void testAdminsAccessToPerformXSiteOps() {
        this.assertXSiteOps(TestUser.ADMIN, 200, 204);
    }

    @Test
    public void testRestNonAdminsMustNotAccessPerformXSiteOps() {
        for (TestUser user : TestUser.NON_ADMINS) {
            this.assertXSiteOps(user, 403, 403);
        }
    }

    private void assertXSiteOps(TestUser user, int status, int noContentStatus) {
        RestClientConfigurationBuilder userConfig = this.restBuilders.get(user);
        RestClient client = this.getServerTest().rest().withClientConfiguration(userConfig).get();
        RestCacheClient xsiteCache = client.cache("xsite");
        Common.assertStatus(status, xsiteCache.takeSiteOffline("NYC"));
        Common.assertStatus(status, xsiteCache.bringSiteOnline("NYC"));
        Common.assertStatus(status, xsiteCache.cancelPushState("NYC"));
        Common.assertStatus(status, xsiteCache.cancelReceiveState("NYC"));
        Common.assertStatus(status, xsiteCache.clearPushStateStatus());
        Common.assertStatus(status, xsiteCache.pushSiteState("NYC"));
        Common.assertStatus(status, xsiteCache.pushStateStatus());
        Common.assertStatus(status, xsiteCache.xsiteBackups());
        Common.assertStatus(status, xsiteCache.backupStatus("NYC"));
        Common.assertStatus(status, xsiteCache.getXSiteTakeOfflineConfig("NYC"));
        Common.assertStatus(noContentStatus, xsiteCache.updateXSiteTakeOfflineConfig("NYC", 10, 1000L));
        RestCacheManagerClient xsiteCacheManager = client.cacheManager("default");
        Common.assertStatus(status, xsiteCacheManager.bringBackupOnline("NYC"));
        Common.assertStatus(status, xsiteCacheManager.takeOffline("NYC"));
        Common.assertStatus(status, xsiteCacheManager.backupStatuses());
    }

    @Test
    public void testRestNonAdminsMustNotPerformSearchActions() {
        String schema = (String)Exceptions.unchecked(() -> Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)this.getClass().getClassLoader()));
        Common.assertStatus(200, this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(TestUser.ADMIN)).get().schemas().put(BANK_PROTO, schema));
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.indexing().enable().addIndexedEntity("sample_bank_account.User").statistics().enable();
        RestClient restClient = ((RestTestClientDriver)this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(TestUser.ADMIN)).withServerConfiguration(builder)).create();
        String indexedCache = this.getServerTest().getMethodName();
        RestCacheClient cache = restClient.cache(indexedCache);
        for (TestUser user : TestUser.NON_ADMINS) {
            this.searchActions(user, indexedCache, 403, 403);
        }
        this.searchActions(TestUser.ADMIN, indexedCache, 200, 204);
    }

    private void searchActions(TestUser user, String indexedCache, int status, int noContentStatus) {
        RestClient client = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get();
        Common.assertStatus(status, client.cache(indexedCache).clearSearchStats());
        Common.assertStatus(noContentStatus, client.cache(indexedCache).reindex());
        Common.assertStatus(noContentStatus, client.cache(indexedCache).clearIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestAdminsMustAccessBackupsAndRestores() throws IOException {
        String BACKUP_NAME = "backup";
        RestClusterClient client = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(TestUser.ADMIN)).get().cluster();
        Common.assertStatus(202, client.createBackup(BACKUP_NAME));
        RestResponse response = Common.awaitStatus(() -> client.getBackup(BACKUP_NAME, false), 202, 200);
        String fileName = response.getHeader("Content-Disposition").split("=")[1];
        File backupZip = new File(this.getServers().getServerDriver().getRootDir(), fileName);
        try (InputStream is = response.getBodyAsStream();){
            Files.copy(is, backupZip.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            response.close();
        }
        Common.assertStatus(204, client.deleteBackup(BACKUP_NAME));
        Common.assertStatus(200, client.getBackupNames());
        Common.assertStatus(202, client.restore(BACKUP_NAME, backupZip));
        Common.assertStatus(200, client.getRestoreNames());
        Common.awaitStatus(() -> client.getRestore(BACKUP_NAME), 202, 201);
        Common.assertStatus(204, client.deleteRestore(BACKUP_NAME));
    }

    @Test
    public void testRestNonAdminsMustNotAccessBackupsAndRestores() {
        for (TestUser user : TestUser.NON_ADMINS) {
            RestClusterClient client = this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(user)).get().cluster();
            Common.assertStatus(403, client.createBackup("backup"));
            Common.assertStatus(403, client.getBackup("backup", true));
            Common.assertStatus(403, client.getBackupNames());
            Common.assertStatus(403, client.deleteBackup("backup"));
            Common.assertStatus(403, client.restore("restore", "somewhere"));
            Common.assertStatus(403, client.getRestoreNames());
            Common.assertStatus(403, client.getRestore("restore"));
            Common.assertStatus(403, client.deleteRestore("restore"));
        }
    }

    private <K, V> RemoteCache<K, V> hotRodCreateAuthzCache(String ... explicitRoles) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        AuthorizationConfigurationBuilder authorizationConfigurationBuilder = builder.clustering().cacheMode(CacheMode.DIST_SYNC).security().authorization().enable();
        if (explicitRoles != null) {
            for (String role : explicitRoles) {
                authorizationConfigurationBuilder.role(role);
            }
        }
        return ((HotRodTestClientDriver)this.getServerTest().hotrod().withClientConfiguration(this.hotRodBuilders.get(TestUser.ADMIN)).withServerConfiguration(builder)).create();
    }

    private RestClient restCreateAuthzCache(String ... explicitRoles) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        AuthorizationConfigurationBuilder authorizationConfigurationBuilder = builder.clustering().cacheMode(CacheMode.DIST_SYNC).security().authorization().enable();
        if (explicitRoles != null) {
            for (String role : explicitRoles) {
                authorizationConfigurationBuilder.role(role);
            }
        }
        return ((RestTestClientDriver)this.getServerTest().rest().withClientConfiguration(this.restBuilders.get(TestUser.ADMIN)).withServerConfiguration(builder)).create();
    }
}

